package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  MaximumExecutionTimeoutInSeconds,
  TerminationWaitInSeconds
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class BlueGreenUpdatePolicy(
    trafficRoutingConfiguration: zio.aws.sagemaker.model.TrafficRoutingConfig,
    terminationWaitInSeconds: Optional[TerminationWaitInSeconds] =
      Optional.Absent,
    maximumExecutionTimeoutInSeconds: Optional[
      MaximumExecutionTimeoutInSeconds
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.BlueGreenUpdatePolicy = {
    import BlueGreenUpdatePolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.BlueGreenUpdatePolicy
      .builder()
      .trafficRoutingConfiguration(trafficRoutingConfiguration.buildAwsValue())
      .optionallyWith(
        terminationWaitInSeconds.map(value =>
          TerminationWaitInSeconds.unwrap(value): Integer
        )
      )(_.terminationWaitInSeconds)
      .optionallyWith(
        maximumExecutionTimeoutInSeconds.map(value =>
          MaximumExecutionTimeoutInSeconds.unwrap(value): Integer
        )
      )(_.maximumExecutionTimeoutInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.BlueGreenUpdatePolicy.ReadOnly =
    zio.aws.sagemaker.model.BlueGreenUpdatePolicy.wrap(buildAwsValue())
}
object BlueGreenUpdatePolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.BlueGreenUpdatePolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.BlueGreenUpdatePolicy =
      zio.aws.sagemaker.model.BlueGreenUpdatePolicy(
        trafficRoutingConfiguration.asEditable,
        terminationWaitInSeconds.map(value => value),
        maximumExecutionTimeoutInSeconds.map(value => value)
      )
    def trafficRoutingConfiguration
        : zio.aws.sagemaker.model.TrafficRoutingConfig.ReadOnly
    def terminationWaitInSeconds: Optional[TerminationWaitInSeconds]
    def maximumExecutionTimeoutInSeconds
        : Optional[MaximumExecutionTimeoutInSeconds]
    def getTrafficRoutingConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.TrafficRoutingConfig.ReadOnly
    ] = ZIO.succeed(trafficRoutingConfiguration)
    def getTerminationWaitInSeconds
        : ZIO[Any, AwsError, TerminationWaitInSeconds] = AwsError
      .unwrapOptionField("terminationWaitInSeconds", terminationWaitInSeconds)
    def getMaximumExecutionTimeoutInSeconds
        : ZIO[Any, AwsError, MaximumExecutionTimeoutInSeconds] =
      AwsError.unwrapOptionField(
        "maximumExecutionTimeoutInSeconds",
        maximumExecutionTimeoutInSeconds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.BlueGreenUpdatePolicy
  ) extends zio.aws.sagemaker.model.BlueGreenUpdatePolicy.ReadOnly {
    override val trafficRoutingConfiguration
        : zio.aws.sagemaker.model.TrafficRoutingConfig.ReadOnly =
      zio.aws.sagemaker.model.TrafficRoutingConfig
        .wrap(impl.trafficRoutingConfiguration())
    override val terminationWaitInSeconds: Optional[TerminationWaitInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.terminationWaitInSeconds())
        .map(value =>
          zio.aws.sagemaker.model.primitives.TerminationWaitInSeconds(value)
        )
    override val maximumExecutionTimeoutInSeconds
        : Optional[MaximumExecutionTimeoutInSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.maximumExecutionTimeoutInSeconds())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .MaximumExecutionTimeoutInSeconds(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.BlueGreenUpdatePolicy
  ): zio.aws.sagemaker.model.BlueGreenUpdatePolicy.ReadOnly = new Wrapper(impl)
}
