package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  HubSearchKeyword,
  HubDisplayName,
  HubDescription,
  HubName
}
import scala.jdk.CollectionConverters.*
final case class UpdateHubRequest(
    hubName: HubName,
    hubDescription: Optional[HubDescription] = Optional.Absent,
    hubDisplayName: Optional[HubDisplayName] = Optional.Absent,
    hubSearchKeywords: Optional[Iterable[HubSearchKeyword]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateHubRequest = {
    import UpdateHubRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateHubRequest
      .builder()
      .hubName(HubName.unwrap(hubName): java.lang.String)
      .optionallyWith(
        hubDescription.map(value =>
          HubDescription.unwrap(value): java.lang.String
        )
      )(_.hubDescription)
      .optionallyWith(
        hubDisplayName.map(value =>
          HubDisplayName.unwrap(value): java.lang.String
        )
      )(_.hubDisplayName)
      .optionallyWith(
        hubSearchKeywords.map(value =>
          value.map { item =>
            HubSearchKeyword.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.hubSearchKeywords)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateHubRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateHubRequest.wrap(buildAwsValue())
}
object UpdateHubRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateHubRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateHubRequest =
      zio.aws.sagemaker.model.UpdateHubRequest(
        hubName,
        hubDescription.map(value => value),
        hubDisplayName.map(value => value),
        hubSearchKeywords.map(value => value)
      )
    def hubName: HubName
    def hubDescription: Optional[HubDescription]
    def hubDisplayName: Optional[HubDisplayName]
    def hubSearchKeywords: Optional[List[HubSearchKeyword]]
    def getHubName: ZIO[Any, Nothing, HubName] = ZIO.succeed(hubName)
    def getHubDescription: ZIO[Any, AwsError, HubDescription] =
      AwsError.unwrapOptionField("hubDescription", hubDescription)
    def getHubDisplayName: ZIO[Any, AwsError, HubDisplayName] =
      AwsError.unwrapOptionField("hubDisplayName", hubDisplayName)
    def getHubSearchKeywords: ZIO[Any, AwsError, List[HubSearchKeyword]] =
      AwsError.unwrapOptionField("hubSearchKeywords", hubSearchKeywords)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateHubRequest
  ) extends zio.aws.sagemaker.model.UpdateHubRequest.ReadOnly {
    override val hubName: HubName =
      zio.aws.sagemaker.model.primitives.HubName(impl.hubName())
    override val hubDescription: Optional[HubDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hubDescription())
        .map(value => zio.aws.sagemaker.model.primitives.HubDescription(value))
    override val hubDisplayName: Optional[HubDisplayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hubDisplayName())
        .map(value => zio.aws.sagemaker.model.primitives.HubDisplayName(value))
    override val hubSearchKeywords: Optional[List[HubSearchKeyword]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hubSearchKeywords())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.HubSearchKeyword(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateHubRequest
  ): zio.aws.sagemaker.model.UpdateHubRequest.ReadOnly = new Wrapper(impl)
}
