package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{SnsTopicArn, KmsKeyId, S3Uri}
import scala.jdk.CollectionConverters.*
final case class LabelingJobOutputConfig(
    s3OutputPath: S3Uri,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    snsTopicArn: Optional[SnsTopicArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.LabelingJobOutputConfig = {
    import LabelingJobOutputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.LabelingJobOutputConfig
      .builder()
      .s3OutputPath(S3Uri.unwrap(s3OutputPath): java.lang.String)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        snsTopicArn.map(value => SnsTopicArn.unwrap(value): java.lang.String)
      )(_.snsTopicArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.LabelingJobOutputConfig.ReadOnly =
    zio.aws.sagemaker.model.LabelingJobOutputConfig.wrap(buildAwsValue())
}
object LabelingJobOutputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.LabelingJobOutputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.LabelingJobOutputConfig =
      zio.aws.sagemaker.model.LabelingJobOutputConfig(
        s3OutputPath,
        kmsKeyId.map(value => value),
        snsTopicArn.map(value => value)
      )
    def s3OutputPath: S3Uri
    def kmsKeyId: Optional[KmsKeyId]
    def snsTopicArn: Optional[SnsTopicArn]
    def getS3OutputPath: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3OutputPath)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getSnsTopicArn: ZIO[Any, AwsError, SnsTopicArn] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelingJobOutputConfig
  ) extends zio.aws.sagemaker.model.LabelingJobOutputConfig.ReadOnly {
    override val s3OutputPath: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.s3OutputPath())
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val snsTopicArn: Optional[SnsTopicArn] = zio.aws.core.internal
      .optionalFromNullable(impl.snsTopicArn())
      .map(value => zio.aws.sagemaker.model.primitives.SnsTopicArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelingJobOutputConfig
  ): zio.aws.sagemaker.model.LabelingJobOutputConfig.ReadOnly = new Wrapper(
    impl
  )
}
