package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait JobType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.JobType
}
object JobType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.JobType
  ): zio.aws.sagemaker.model.JobType = value match {
    case software.amazon.awssdk.services.sagemaker.model.JobType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.JobType.TRAINING =>
      val r = TRAINING
      r
    case software.amazon.awssdk.services.sagemaker.model.JobType.INFERENCE =>
      val r = INFERENCE
      r
    case software.amazon.awssdk.services.sagemaker.model.JobType.NOTEBOOK_KERNEL =>
      val r = NOTEBOOK_KERNEL
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.JobType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.JobType =
      software.amazon.awssdk.services.sagemaker.model.JobType.UNKNOWN_TO_SDK_VERSION
  }
  case object TRAINING extends zio.aws.sagemaker.model.JobType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.JobType =
      software.amazon.awssdk.services.sagemaker.model.JobType.TRAINING
  }
  case object INFERENCE extends zio.aws.sagemaker.model.JobType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.JobType =
      software.amazon.awssdk.services.sagemaker.model.JobType.INFERENCE
  }
  case object NOTEBOOK_KERNEL extends zio.aws.sagemaker.model.JobType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.JobType =
      software.amazon.awssdk.services.sagemaker.model.JobType.NOTEBOOK_KERNEL
  }
}
