package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class InferenceMetrics(
    maxInvocations: Integer,
    modelLatency: Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.InferenceMetrics = {
    import InferenceMetrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.InferenceMetrics
      .builder()
      .maxInvocations(maxInvocations: java.lang.Integer)
      .modelLatency(modelLatency: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.InferenceMetrics.ReadOnly =
    zio.aws.sagemaker.model.InferenceMetrics.wrap(buildAwsValue())
}
object InferenceMetrics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.InferenceMetrics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.InferenceMetrics =
      zio.aws.sagemaker.model.InferenceMetrics(maxInvocations, modelLatency)
    def maxInvocations: Integer
    def modelLatency: Integer
    def getMaxInvocations: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(maxInvocations)
    def getModelLatency: ZIO[Any, Nothing, Integer] = ZIO.succeed(modelLatency)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.InferenceMetrics
  ) extends zio.aws.sagemaker.model.InferenceMetrics.ReadOnly {
    override val maxInvocations: Integer = impl.maxInvocations(): Integer
    override val modelLatency: Integer = impl.modelLatency(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.InferenceMetrics
  ): zio.aws.sagemaker.model.InferenceMetrics.ReadOnly = new Wrapper(impl)
}
