package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  Timestamp,
  InferenceExperimentName,
  InferenceExperimentDescription,
  InferenceExperimentStatusReason
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class InferenceExperimentSummary(
    name: InferenceExperimentName,
    `type`: zio.aws.sagemaker.model.InferenceExperimentType,
    schedule: Optional[zio.aws.sagemaker.model.InferenceExperimentSchedule] =
      Optional.Absent,
    status: zio.aws.sagemaker.model.InferenceExperimentStatus,
    statusReason: Optional[InferenceExperimentStatusReason] = Optional.Absent,
    description: Optional[InferenceExperimentDescription] = Optional.Absent,
    creationTime: Timestamp,
    completionTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Timestamp,
    roleArn: Optional[RoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.InferenceExperimentSummary = {
    import InferenceExperimentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.InferenceExperimentSummary
      .builder()
      .name(InferenceExperimentName.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .status(status.unwrap)
      .optionallyWith(
        statusReason.map(value =>
          InferenceExperimentStatusReason.unwrap(value): java.lang.String
        )
      )(_.statusReason)
      .optionallyWith(
        description.map(value =>
          InferenceExperimentDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(
        completionTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.completionTime)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.InferenceExperimentSummary.ReadOnly =
    zio.aws.sagemaker.model.InferenceExperimentSummary.wrap(buildAwsValue())
}
object InferenceExperimentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.InferenceExperimentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.InferenceExperimentSummary =
      zio.aws.sagemaker.model.InferenceExperimentSummary(
        name,
        `type`,
        schedule.map(value => value.asEditable),
        status,
        statusReason.map(value => value),
        description.map(value => value),
        creationTime,
        completionTime.map(value => value),
        lastModifiedTime,
        roleArn.map(value => value)
      )
    def name: InferenceExperimentName
    def `type`: zio.aws.sagemaker.model.InferenceExperimentType
    def schedule
        : Optional[zio.aws.sagemaker.model.InferenceExperimentSchedule.ReadOnly]
    def status: zio.aws.sagemaker.model.InferenceExperimentStatus
    def statusReason: Optional[InferenceExperimentStatusReason]
    def description: Optional[InferenceExperimentDescription]
    def creationTime: Timestamp
    def completionTime: Optional[Timestamp]
    def lastModifiedTime: Timestamp
    def roleArn: Optional[RoleArn]
    def getName: ZIO[Any, Nothing, InferenceExperimentName] = ZIO.succeed(name)
    def getType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.InferenceExperimentType] =
      ZIO.succeed(`type`)
    def getSchedule: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.InferenceExperimentSchedule.ReadOnly
    ] = AwsError.unwrapOptionField("schedule", schedule)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.InferenceExperimentStatus] =
      ZIO.succeed(status)
    def getStatusReason: ZIO[Any, AwsError, InferenceExperimentStatusReason] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getDescription: ZIO[Any, AwsError, InferenceExperimentDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getCompletionTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.InferenceExperimentSummary
  ) extends zio.aws.sagemaker.model.InferenceExperimentSummary.ReadOnly {
    override val name: InferenceExperimentName =
      zio.aws.sagemaker.model.primitives.InferenceExperimentName(impl.name())
    override val `type`: zio.aws.sagemaker.model.InferenceExperimentType =
      zio.aws.sagemaker.model.InferenceExperimentType.wrap(impl.`type`())
    override val schedule: Optional[
      zio.aws.sagemaker.model.InferenceExperimentSchedule.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.schedule())
      .map(value =>
        zio.aws.sagemaker.model.InferenceExperimentSchedule.wrap(value)
      )
    override val status: zio.aws.sagemaker.model.InferenceExperimentStatus =
      zio.aws.sagemaker.model.InferenceExperimentStatus.wrap(impl.status())
    override val statusReason: Optional[InferenceExperimentStatusReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusReason())
        .map(value =>
          zio.aws.sagemaker.model.primitives
            .InferenceExperimentStatusReason(value)
        )
    override val description: Optional[InferenceExperimentDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.sagemaker.model.primitives
            .InferenceExperimentDescription(value)
        )
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val completionTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.completionTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.lastModifiedTime())
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.InferenceExperimentSummary
  ): zio.aws.sagemaker.model.InferenceExperimentSummary.ReadOnly = new Wrapper(
    impl
  )
}
