package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  HubSearchKeyword,
  HubContentVersion,
  HubContentName,
  HubContentDescription,
  HubContentDisplayName,
  DocumentSchemaVersion,
  HubName,
  HubContentMarkdown,
  HubContentDocument
}
import scala.jdk.CollectionConverters.*
final case class ImportHubContentRequest(
    hubContentName: HubContentName,
    hubContentVersion: Optional[HubContentVersion] = Optional.Absent,
    hubContentType: zio.aws.sagemaker.model.HubContentType,
    documentSchemaVersion: DocumentSchemaVersion,
    hubName: HubName,
    hubContentDisplayName: Optional[HubContentDisplayName] = Optional.Absent,
    hubContentDescription: Optional[HubContentDescription] = Optional.Absent,
    hubContentMarkdown: Optional[HubContentMarkdown] = Optional.Absent,
    hubContentDocument: HubContentDocument,
    hubContentSearchKeywords: Optional[Iterable[HubSearchKeyword]] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ImportHubContentRequest = {
    import ImportHubContentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ImportHubContentRequest
      .builder()
      .hubContentName(HubContentName.unwrap(hubContentName): java.lang.String)
      .optionallyWith(
        hubContentVersion.map(value =>
          HubContentVersion.unwrap(value): java.lang.String
        )
      )(_.hubContentVersion)
      .hubContentType(hubContentType.unwrap)
      .documentSchemaVersion(
        DocumentSchemaVersion.unwrap(documentSchemaVersion): java.lang.String
      )
      .hubName(HubName.unwrap(hubName): java.lang.String)
      .optionallyWith(
        hubContentDisplayName.map(value =>
          HubContentDisplayName.unwrap(value): java.lang.String
        )
      )(_.hubContentDisplayName)
      .optionallyWith(
        hubContentDescription.map(value =>
          HubContentDescription.unwrap(value): java.lang.String
        )
      )(_.hubContentDescription)
      .optionallyWith(
        hubContentMarkdown.map(value =>
          HubContentMarkdown.unwrap(value): java.lang.String
        )
      )(_.hubContentMarkdown)
      .hubContentDocument(
        HubContentDocument.unwrap(hubContentDocument): java.lang.String
      )
      .optionallyWith(
        hubContentSearchKeywords.map(value =>
          value.map { item =>
            HubSearchKeyword.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.hubContentSearchKeywords)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ImportHubContentRequest.ReadOnly =
    zio.aws.sagemaker.model.ImportHubContentRequest.wrap(buildAwsValue())
}
object ImportHubContentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ImportHubContentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ImportHubContentRequest =
      zio.aws.sagemaker.model.ImportHubContentRequest(
        hubContentName,
        hubContentVersion.map(value => value),
        hubContentType,
        documentSchemaVersion,
        hubName,
        hubContentDisplayName.map(value => value),
        hubContentDescription.map(value => value),
        hubContentMarkdown.map(value => value),
        hubContentDocument,
        hubContentSearchKeywords.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def hubContentName: HubContentName
    def hubContentVersion: Optional[HubContentVersion]
    def hubContentType: zio.aws.sagemaker.model.HubContentType
    def documentSchemaVersion: DocumentSchemaVersion
    def hubName: HubName
    def hubContentDisplayName: Optional[HubContentDisplayName]
    def hubContentDescription: Optional[HubContentDescription]
    def hubContentMarkdown: Optional[HubContentMarkdown]
    def hubContentDocument: HubContentDocument
    def hubContentSearchKeywords: Optional[List[HubSearchKeyword]]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getHubContentName: ZIO[Any, Nothing, HubContentName] =
      ZIO.succeed(hubContentName)
    def getHubContentVersion: ZIO[Any, AwsError, HubContentVersion] =
      AwsError.unwrapOptionField("hubContentVersion", hubContentVersion)
    def getHubContentType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.HubContentType] =
      ZIO.succeed(hubContentType)
    def getDocumentSchemaVersion: ZIO[Any, Nothing, DocumentSchemaVersion] =
      ZIO.succeed(documentSchemaVersion)
    def getHubName: ZIO[Any, Nothing, HubName] = ZIO.succeed(hubName)
    def getHubContentDisplayName: ZIO[Any, AwsError, HubContentDisplayName] =
      AwsError.unwrapOptionField("hubContentDisplayName", hubContentDisplayName)
    def getHubContentDescription: ZIO[Any, AwsError, HubContentDescription] =
      AwsError.unwrapOptionField("hubContentDescription", hubContentDescription)
    def getHubContentMarkdown: ZIO[Any, AwsError, HubContentMarkdown] =
      AwsError.unwrapOptionField("hubContentMarkdown", hubContentMarkdown)
    def getHubContentDocument: ZIO[Any, Nothing, HubContentDocument] =
      ZIO.succeed(hubContentDocument)
    def getHubContentSearchKeywords
        : ZIO[Any, AwsError, List[HubSearchKeyword]] = AwsError
      .unwrapOptionField("hubContentSearchKeywords", hubContentSearchKeywords)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ImportHubContentRequest
  ) extends zio.aws.sagemaker.model.ImportHubContentRequest.ReadOnly {
    override val hubContentName: HubContentName =
      zio.aws.sagemaker.model.primitives.HubContentName(impl.hubContentName())
    override val hubContentVersion: Optional[HubContentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hubContentVersion())
        .map(value =>
          zio.aws.sagemaker.model.primitives.HubContentVersion(value)
        )
    override val hubContentType: zio.aws.sagemaker.model.HubContentType =
      zio.aws.sagemaker.model.HubContentType.wrap(impl.hubContentType())
    override val documentSchemaVersion: DocumentSchemaVersion =
      zio.aws.sagemaker.model.primitives
        .DocumentSchemaVersion(impl.documentSchemaVersion())
    override val hubName: HubName =
      zio.aws.sagemaker.model.primitives.HubName(impl.hubName())
    override val hubContentDisplayName: Optional[HubContentDisplayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hubContentDisplayName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.HubContentDisplayName(value)
        )
    override val hubContentDescription: Optional[HubContentDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hubContentDescription())
        .map(value =>
          zio.aws.sagemaker.model.primitives.HubContentDescription(value)
        )
    override val hubContentMarkdown: Optional[HubContentMarkdown] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hubContentMarkdown())
        .map(value =>
          zio.aws.sagemaker.model.primitives.HubContentMarkdown(value)
        )
    override val hubContentDocument: HubContentDocument =
      zio.aws.sagemaker.model.primitives
        .HubContentDocument(impl.hubContentDocument())
    override val hubContentSearchKeywords: Optional[List[HubSearchKeyword]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hubContentSearchKeywords())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.HubSearchKeyword(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ImportHubContentRequest
  ): zio.aws.sagemaker.model.ImportHubContentRequest.ReadOnly = new Wrapper(
    impl
  )
}
