package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait HubSortBy {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.HubSortBy
}
object HubSortBy {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.HubSortBy
  ): zio.aws.sagemaker.model.HubSortBy = value match {
    case software.amazon.awssdk.services.sagemaker.model.HubSortBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.HubSortBy.HUB_NAME =>
      val r = HubName
      r
    case software.amazon.awssdk.services.sagemaker.model.HubSortBy.CREATION_TIME =>
      val r = CreationTime
      r
    case software.amazon.awssdk.services.sagemaker.model.HubSortBy.HUB_STATUS =>
      val r = HubStatus
      r
    case software.amazon.awssdk.services.sagemaker.model.HubSortBy.ACCOUNT_ID_OWNER =>
      val r = AccountIdOwner
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.HubSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HubSortBy =
      software.amazon.awssdk.services.sagemaker.model.HubSortBy.UNKNOWN_TO_SDK_VERSION
  }
  case object HubName extends zio.aws.sagemaker.model.HubSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HubSortBy =
      software.amazon.awssdk.services.sagemaker.model.HubSortBy.HUB_NAME
  }
  case object CreationTime extends zio.aws.sagemaker.model.HubSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HubSortBy =
      software.amazon.awssdk.services.sagemaker.model.HubSortBy.CREATION_TIME
  }
  case object HubStatus extends zio.aws.sagemaker.model.HubSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HubSortBy =
      software.amazon.awssdk.services.sagemaker.model.HubSortBy.HUB_STATUS
  }
  case object AccountIdOwner extends zio.aws.sagemaker.model.HubSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HubSortBy =
      software.amazon.awssdk.services.sagemaker.model.HubSortBy.ACCOUNT_ID_OWNER
  }
}
