package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  SageMakerImageVersionAlias,
  ImageVersionNumber,
  ImageName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeImageVersionRequest(
    imageName: ImageName,
    version: Optional[ImageVersionNumber] = Optional.Absent,
    alias: Optional[SageMakerImageVersionAlias] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionRequest = {
    import DescribeImageVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionRequest
      .builder()
      .imageName(ImageName.unwrap(imageName): java.lang.String)
      .optionallyWith(
        version.map(value => ImageVersionNumber.unwrap(value): Integer)
      )(_.version)
      .optionallyWith(
        alias.map(value =>
          SageMakerImageVersionAlias.unwrap(value): java.lang.String
        )
      )(_.alias)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeImageVersionRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeImageVersionRequest.wrap(buildAwsValue())
}
object DescribeImageVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeImageVersionRequest =
      zio.aws.sagemaker.model.DescribeImageVersionRequest(
        imageName,
        version.map(value => value),
        alias.map(value => value)
      )
    def imageName: ImageName
    def version: Optional[ImageVersionNumber]
    def alias: Optional[SageMakerImageVersionAlias]
    def getImageName: ZIO[Any, Nothing, ImageName] = ZIO.succeed(imageName)
    def getVersion: ZIO[Any, AwsError, ImageVersionNumber] =
      AwsError.unwrapOptionField("version", version)
    def getAlias: ZIO[Any, AwsError, SageMakerImageVersionAlias] =
      AwsError.unwrapOptionField("alias", alias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionRequest
  ) extends zio.aws.sagemaker.model.DescribeImageVersionRequest.ReadOnly {
    override val imageName: ImageName =
      zio.aws.sagemaker.model.primitives.ImageName(impl.imageName())
    override val version: Optional[ImageVersionNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ImageVersionNumber(value)
      )
    override val alias: Optional[SageMakerImageVersionAlias] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alias())
        .map(value =>
          zio.aws.sagemaker.model.primitives.SageMakerImageVersionAlias(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionRequest
  ): zio.aws.sagemaker.model.DescribeImageVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
