package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  SpaceName,
  AppName,
  UserProfileName,
  DomainId
}
import scala.jdk.CollectionConverters.*
final case class DescribeAppRequest(
    domainId: DomainId,
    userProfileName: Optional[UserProfileName] = Optional.Absent,
    appType: zio.aws.sagemaker.model.AppType,
    appName: AppName,
    spaceName: Optional[SpaceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeAppRequest = {
    import DescribeAppRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeAppRequest
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .optionallyWith(
        userProfileName.map(value =>
          UserProfileName.unwrap(value): java.lang.String
        )
      )(_.userProfileName)
      .appType(appType.unwrap)
      .appName(AppName.unwrap(appName): java.lang.String)
      .optionallyWith(
        spaceName.map(value => SpaceName.unwrap(value): java.lang.String)
      )(_.spaceName)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeAppRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeAppRequest.wrap(buildAwsValue())
}
object DescribeAppRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeAppRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeAppRequest =
      zio.aws.sagemaker.model.DescribeAppRequest(
        domainId,
        userProfileName.map(value => value),
        appType,
        appName,
        spaceName.map(value => value)
      )
    def domainId: DomainId
    def userProfileName: Optional[UserProfileName]
    def appType: zio.aws.sagemaker.model.AppType
    def appName: AppName
    def spaceName: Optional[SpaceName]
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getUserProfileName: ZIO[Any, AwsError, UserProfileName] =
      AwsError.unwrapOptionField("userProfileName", userProfileName)
    def getAppType: ZIO[Any, Nothing, zio.aws.sagemaker.model.AppType] =
      ZIO.succeed(appType)
    def getAppName: ZIO[Any, Nothing, AppName] = ZIO.succeed(appName)
    def getSpaceName: ZIO[Any, AwsError, SpaceName] =
      AwsError.unwrapOptionField("spaceName", spaceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeAppRequest
  ) extends zio.aws.sagemaker.model.DescribeAppRequest.ReadOnly {
    override val domainId: DomainId =
      zio.aws.sagemaker.model.primitives.DomainId(impl.domainId())
    override val userProfileName: Optional[UserProfileName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userProfileName())
        .map(value => zio.aws.sagemaker.model.primitives.UserProfileName(value))
    override val appType: zio.aws.sagemaker.model.AppType =
      zio.aws.sagemaker.model.AppType.wrap(impl.appType())
    override val appName: AppName =
      zio.aws.sagemaker.model.primitives.AppName(impl.appName())
    override val spaceName: Optional[SpaceName] = zio.aws.core.internal
      .optionalFromNullable(impl.spaceName())
      .map(value => zio.aws.sagemaker.model.primitives.SpaceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeAppRequest
  ): zio.aws.sagemaker.model.DescribeAppRequest.ReadOnly = new Wrapper(impl)
}
