package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.DomainId
import scala.jdk.CollectionConverters.*
final case class DeleteDomainRequest(
    domainId: DomainId,
    retentionPolicy: Optional[zio.aws.sagemaker.model.RetentionPolicy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteDomainRequest = {
    import DeleteDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteDomainRequest
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .optionallyWith(retentionPolicy.map(value => value.buildAwsValue()))(
        _.retentionPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteDomainRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteDomainRequest.wrap(buildAwsValue())
}
object DeleteDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteDomainRequest =
      zio.aws.sagemaker.model.DeleteDomainRequest(
        domainId,
        retentionPolicy.map(value => value.asEditable)
      )
    def domainId: DomainId
    def retentionPolicy
        : Optional[zio.aws.sagemaker.model.RetentionPolicy.ReadOnly]
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getRetentionPolicy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.RetentionPolicy.ReadOnly] =
      AwsError.unwrapOptionField("retentionPolicy", retentionPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteDomainRequest
  ) extends zio.aws.sagemaker.model.DeleteDomainRequest.ReadOnly {
    override val domainId: DomainId =
      zio.aws.sagemaker.model.primitives.DomainId(impl.domainId())
    override val retentionPolicy
        : Optional[zio.aws.sagemaker.model.RetentionPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retentionPolicy())
        .map(value => zio.aws.sagemaker.model.RetentionPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteDomainRequest
  ): zio.aws.sagemaker.model.DeleteDomainRequest.ReadOnly = new Wrapper(impl)
}
