package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{String256, String2048}
import scala.jdk.CollectionConverters.*
final case class ContextSource(
    sourceUri: String2048,
    sourceType: Optional[String256] = Optional.Absent,
    sourceId: Optional[String256] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ContextSource = {
    import ContextSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ContextSource
      .builder()
      .sourceUri(String2048.unwrap(sourceUri): java.lang.String)
      .optionallyWith(
        sourceType.map(value => String256.unwrap(value): java.lang.String)
      )(_.sourceType)
      .optionallyWith(
        sourceId.map(value => String256.unwrap(value): java.lang.String)
      )(_.sourceId)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ContextSource.ReadOnly =
    zio.aws.sagemaker.model.ContextSource.wrap(buildAwsValue())
}
object ContextSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ContextSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ContextSource =
      zio.aws.sagemaker.model.ContextSource(
        sourceUri,
        sourceType.map(value => value),
        sourceId.map(value => value)
      )
    def sourceUri: String2048
    def sourceType: Optional[String256]
    def sourceId: Optional[String256]
    def getSourceUri: ZIO[Any, Nothing, String2048] = ZIO.succeed(sourceUri)
    def getSourceType: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getSourceId: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("sourceId", sourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ContextSource
  ) extends zio.aws.sagemaker.model.ContextSource.ReadOnly {
    override val sourceUri: String2048 =
      zio.aws.sagemaker.model.primitives.String2048(impl.sourceUri())
    override val sourceType: Optional[String256] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceType())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val sourceId: Optional[String256] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceId())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ContextSource
  ): zio.aws.sagemaker.model.ContextSource.ReadOnly = new Wrapper(impl)
}
