package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.AutoMLJobArn
import scala.jdk.CollectionConverters.*
final case class AutoMLJobStepMetadata(
    arn: Optional[AutoMLJobArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AutoMLJobStepMetadata = {
    import AutoMLJobStepMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AutoMLJobStepMetadata
      .builder()
      .optionallyWith(
        arn.map(value => AutoMLJobArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AutoMLJobStepMetadata.ReadOnly =
    zio.aws.sagemaker.model.AutoMLJobStepMetadata.wrap(buildAwsValue())
}
object AutoMLJobStepMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AutoMLJobStepMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AutoMLJobStepMetadata =
      zio.aws.sagemaker.model.AutoMLJobStepMetadata(arn.map(value => value))
    def arn: Optional[AutoMLJobArn]
    def getArn: ZIO[Any, AwsError, AutoMLJobArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLJobStepMetadata
  ) extends zio.aws.sagemaker.model.AutoMLJobStepMetadata.ReadOnly {
    override val arn: Optional[AutoMLJobArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.sagemaker.model.primitives.AutoMLJobArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLJobStepMetadata
  ): zio.aws.sagemaker.model.AutoMLJobStepMetadata.ReadOnly = new Wrapper(impl)
}
