package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{MaxResults, NextToken, Timestamp}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListFlowDefinitionsRequest(
    creationTimeAfter: Optional[Timestamp] = Optional.Absent,
    creationTimeBefore: Optional[Timestamp] = Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsRequest = {
    import ListFlowDefinitionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsRequest
      .builder()
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListFlowDefinitionsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListFlowDefinitionsRequest.wrap(buildAwsValue())
}
object ListFlowDefinitionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListFlowDefinitionsRequest =
      zio.aws.sagemaker.model.ListFlowDefinitionsRequest(
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        sortOrder.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def creationTimeAfter: Optional[Timestamp]
    def creationTimeBefore: Optional[Timestamp]
    def sortOrder: Optional[zio.aws.sagemaker.model.SortOrder]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsRequest
  ) extends zio.aws.sagemaker.model.ListFlowDefinitionsRequest.ReadOnly {
    override val creationTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsRequest
  ): zio.aws.sagemaker.model.ListFlowDefinitionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
