package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  String1024,
  DomainName,
  LastModifiedTime,
  DomainId,
  DomainArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DomainDetails(
    domainArn: Optional[DomainArn] = Optional.Absent,
    domainId: Optional[DomainId] = Optional.Absent,
    domainName: Optional[DomainName] = Optional.Absent,
    status: Optional[zio.aws.sagemaker.model.DomainStatus] = Optional.Absent,
    creationTime: Optional[CreationTime] = Optional.Absent,
    lastModifiedTime: Optional[LastModifiedTime] = Optional.Absent,
    url: Optional[String1024] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DomainDetails = {
    import DomainDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DomainDetails
      .builder()
      .optionallyWith(
        domainArn.map(value => DomainArn.unwrap(value): java.lang.String)
      )(_.domainArn)
      .optionallyWith(
        domainId.map(value => DomainId.unwrap(value): java.lang.String)
      )(_.domainId)
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => LastModifiedTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        url.map(value => String1024.unwrap(value): java.lang.String)
      )(_.url)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DomainDetails.ReadOnly =
    zio.aws.sagemaker.model.DomainDetails.wrap(buildAwsValue())
}
object DomainDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DomainDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DomainDetails =
      zio.aws.sagemaker.model.DomainDetails(
        domainArn.map(value => value),
        domainId.map(value => value),
        domainName.map(value => value),
        status.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        url.map(value => value)
      )
    def domainArn: Optional[DomainArn]
    def domainId: Optional[DomainId]
    def domainName: Optional[DomainName]
    def status: Optional[zio.aws.sagemaker.model.DomainStatus]
    def creationTime: Optional[CreationTime]
    def lastModifiedTime: Optional[LastModifiedTime]
    def url: Optional[String1024]
    def getDomainArn: ZIO[Any, AwsError, DomainArn] =
      AwsError.unwrapOptionField("domainArn", domainArn)
    def getDomainId: ZIO[Any, AwsError, DomainId] =
      AwsError.unwrapOptionField("domainId", domainId)
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getStatus: ZIO[Any, AwsError, zio.aws.sagemaker.model.DomainStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getUrl: ZIO[Any, AwsError, String1024] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DomainDetails
  ) extends zio.aws.sagemaker.model.DomainDetails.ReadOnly {
    override val domainArn: Optional[DomainArn] = zio.aws.core.internal
      .optionalFromNullable(impl.domainArn())
      .map(value => zio.aws.sagemaker.model.primitives.DomainArn(value))
    override val domainId: Optional[DomainId] = zio.aws.core.internal
      .optionalFromNullable(impl.domainId())
      .map(value => zio.aws.sagemaker.model.primitives.DomainId(value))
    override val domainName: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.sagemaker.model.primitives.DomainName(value))
    override val status: Optional[zio.aws.sagemaker.model.DomainStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sagemaker.model.DomainStatus.wrap(value))
    override val creationTime: Optional[CreationTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val lastModifiedTime: Optional[LastModifiedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTime())
        .map(value =>
          zio.aws.sagemaker.model.primitives.LastModifiedTime(value)
        )
    override val url: Optional[String1024] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => zio.aws.sagemaker.model.primitives.String1024(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DomainDetails
  ): zio.aws.sagemaker.model.DomainDetails.ReadOnly = new Wrapper(impl)
}
