package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters.*
final case class DeleteAlgorithmRequest(algorithmName: EntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteAlgorithmRequest = {
    import DeleteAlgorithmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteAlgorithmRequest
      .builder()
      .algorithmName(EntityName.unwrap(algorithmName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteAlgorithmRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteAlgorithmRequest.wrap(buildAwsValue())
}
object DeleteAlgorithmRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteAlgorithmRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteAlgorithmRequest =
      zio.aws.sagemaker.model.DeleteAlgorithmRequest(algorithmName)
    def algorithmName: EntityName
    def getAlgorithmName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(algorithmName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteAlgorithmRequest
  ) extends zio.aws.sagemaker.model.DeleteAlgorithmRequest.ReadOnly {
    override val algorithmName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.algorithmName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteAlgorithmRequest
  ): zio.aws.sagemaker.model.DeleteAlgorithmRequest.ReadOnly = new Wrapper(impl)
}
