package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{DestinationS3Uri, KmsKeyId}
import scala.jdk.CollectionConverters.*
final case class AsyncInferenceOutputConfig(
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    s3OutputPath: DestinationS3Uri,
    notificationConfig: Optional[
      zio.aws.sagemaker.model.AsyncInferenceNotificationConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AsyncInferenceOutputConfig = {
    import AsyncInferenceOutputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AsyncInferenceOutputConfig
      .builder()
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .s3OutputPath(DestinationS3Uri.unwrap(s3OutputPath): java.lang.String)
      .optionallyWith(notificationConfig.map(value => value.buildAwsValue()))(
        _.notificationConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AsyncInferenceOutputConfig.ReadOnly =
    zio.aws.sagemaker.model.AsyncInferenceOutputConfig.wrap(buildAwsValue())
}
object AsyncInferenceOutputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AsyncInferenceOutputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AsyncInferenceOutputConfig =
      zio.aws.sagemaker.model.AsyncInferenceOutputConfig(
        kmsKeyId.map(value => value),
        s3OutputPath,
        notificationConfig.map(value => value.asEditable)
      )
    def kmsKeyId: Optional[KmsKeyId]
    def s3OutputPath: DestinationS3Uri
    def notificationConfig: Optional[
      zio.aws.sagemaker.model.AsyncInferenceNotificationConfig.ReadOnly
    ]
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getS3OutputPath: ZIO[Any, Nothing, DestinationS3Uri] =
      ZIO.succeed(s3OutputPath)
    def getNotificationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AsyncInferenceNotificationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("notificationConfig", notificationConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AsyncInferenceOutputConfig
  ) extends zio.aws.sagemaker.model.AsyncInferenceOutputConfig.ReadOnly {
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val s3OutputPath: DestinationS3Uri =
      zio.aws.sagemaker.model.primitives.DestinationS3Uri(impl.s3OutputPath())
    override val notificationConfig: Optional[
      zio.aws.sagemaker.model.AsyncInferenceNotificationConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.notificationConfig())
      .map(value =>
        zio.aws.sagemaker.model.AsyncInferenceNotificationConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AsyncInferenceOutputConfig
  ): zio.aws.sagemaker.model.AsyncInferenceOutputConfig.ReadOnly = new Wrapper(
    impl
  )
}
