package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait JoinSource {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.JoinSource
}
object JoinSource {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.JoinSource
  ): zio.aws.sagemaker.model.JoinSource = value match {
    case software.amazon.awssdk.services.sagemaker.model.JoinSource.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.JoinSource.INPUT =>
      val r = Input
      r
    case software.amazon.awssdk.services.sagemaker.model.JoinSource.NONE =>
      val r = None
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.JoinSource {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.JoinSource =
      software.amazon.awssdk.services.sagemaker.model.JoinSource.UNKNOWN_TO_SDK_VERSION
  }
  case object Input extends zio.aws.sagemaker.model.JoinSource {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.JoinSource =
      software.amazon.awssdk.services.sagemaker.model.JoinSource.INPUT
  }
  case object None extends zio.aws.sagemaker.model.JoinSource {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.JoinSource =
      software.amazon.awssdk.services.sagemaker.model.JoinSource.NONE
  }
}
