package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class InferenceExecutionConfig(
    mode: zio.aws.sagemaker.model.InferenceExecutionMode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.InferenceExecutionConfig = {
    import InferenceExecutionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.InferenceExecutionConfig
      .builder()
      .mode(mode.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.InferenceExecutionConfig.ReadOnly =
    zio.aws.sagemaker.model.InferenceExecutionConfig.wrap(buildAwsValue())
}
object InferenceExecutionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.InferenceExecutionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.InferenceExecutionConfig =
      zio.aws.sagemaker.model.InferenceExecutionConfig(mode)
    def mode: zio.aws.sagemaker.model.InferenceExecutionMode
    def getMode
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.InferenceExecutionMode] =
      ZIO.succeed(mode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.InferenceExecutionConfig
  ) extends zio.aws.sagemaker.model.InferenceExecutionConfig.ReadOnly {
    override val mode: zio.aws.sagemaker.model.InferenceExecutionMode =
      zio.aws.sagemaker.model.InferenceExecutionMode.wrap(impl.mode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.InferenceExecutionConfig
  ): zio.aws.sagemaker.model.InferenceExecutionConfig.ReadOnly = new Wrapper(
    impl
  )
}
