package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  EntityName,
  DeviceFleetArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DeviceFleetSummary(
    deviceFleetArn: DeviceFleetArn,
    deviceFleetName: EntityName,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeviceFleetSummary = {
    import DeviceFleetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeviceFleetSummary
      .builder()
      .deviceFleetArn(DeviceFleetArn.unwrap(deviceFleetArn): java.lang.String)
      .deviceFleetName(EntityName.unwrap(deviceFleetName): java.lang.String)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeviceFleetSummary.ReadOnly =
    zio.aws.sagemaker.model.DeviceFleetSummary.wrap(buildAwsValue())
}
object DeviceFleetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeviceFleetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeviceFleetSummary =
      zio.aws.sagemaker.model.DeviceFleetSummary(
        deviceFleetArn,
        deviceFleetName,
        creationTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def deviceFleetArn: DeviceFleetArn
    def deviceFleetName: EntityName
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def getDeviceFleetArn: ZIO[Any, Nothing, DeviceFleetArn] =
      ZIO.succeed(deviceFleetArn)
    def getDeviceFleetName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(deviceFleetName)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeviceFleetSummary
  ) extends zio.aws.sagemaker.model.DeviceFleetSummary.ReadOnly {
    override val deviceFleetArn: DeviceFleetArn =
      zio.aws.sagemaker.model.primitives.DeviceFleetArn(impl.deviceFleetArn())
    override val deviceFleetName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.deviceFleetName())
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeviceFleetSummary
  ): zio.aws.sagemaker.model.DeviceFleetSummary.ReadOnly = new Wrapper(impl)
}
