package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.MonitoringScheduleName
import scala.jdk.CollectionConverters.*
final case class DescribeMonitoringScheduleRequest(
    monitoringScheduleName: MonitoringScheduleName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeMonitoringScheduleRequest = {
    import DescribeMonitoringScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeMonitoringScheduleRequest
      .builder()
      .monitoringScheduleName(
        MonitoringScheduleName.unwrap(monitoringScheduleName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeMonitoringScheduleRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeMonitoringScheduleRequest
      .wrap(buildAwsValue())
}
object DescribeMonitoringScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeMonitoringScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeMonitoringScheduleRequest =
      zio.aws.sagemaker.model
        .DescribeMonitoringScheduleRequest(monitoringScheduleName)
    def monitoringScheduleName: MonitoringScheduleName
    def getMonitoringScheduleName: ZIO[Any, Nothing, MonitoringScheduleName] =
      ZIO.succeed(monitoringScheduleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeMonitoringScheduleRequest
  ) extends zio.aws.sagemaker.model.DescribeMonitoringScheduleRequest.ReadOnly {
    override val monitoringScheduleName: MonitoringScheduleName =
      zio.aws.sagemaker.model.primitives
        .MonitoringScheduleName(impl.monitoringScheduleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeMonitoringScheduleRequest
  ): zio.aws.sagemaker.model.DescribeMonitoringScheduleRequest.ReadOnly =
    new Wrapper(impl)
}
