package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.WorkforceArn
import scala.jdk.CollectionConverters.*
final case class CreateWorkforceResponse(workforceArn: WorkforceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateWorkforceResponse = {
    import CreateWorkforceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateWorkforceResponse
      .builder()
      .workforceArn(WorkforceArn.unwrap(workforceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateWorkforceResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateWorkforceResponse.wrap(buildAwsValue())
}
object CreateWorkforceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateWorkforceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateWorkforceResponse =
      zio.aws.sagemaker.model.CreateWorkforceResponse(workforceArn)
    def workforceArn: WorkforceArn
    def getWorkforceArn: ZIO[Any, Nothing, WorkforceArn] =
      ZIO.succeed(workforceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateWorkforceResponse
  ) extends zio.aws.sagemaker.model.CreateWorkforceResponse.ReadOnly {
    override val workforceArn: WorkforceArn =
      zio.aws.sagemaker.model.primitives.WorkforceArn(impl.workforceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateWorkforceResponse
  ): zio.aws.sagemaker.model.CreateWorkforceResponse.ReadOnly = new Wrapper(
    impl
  )
}
