package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait ProcessingS3DataDistributionType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ProcessingS3DataDistributionType
}
object ProcessingS3DataDistributionType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ProcessingS3DataDistributionType
  ): zio.aws.sagemaker.model.ProcessingS3DataDistributionType = value match {
    case software.amazon.awssdk.services.sagemaker.model.ProcessingS3DataDistributionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ProcessingS3DataDistributionType.FULLY_REPLICATED =>
      val r = FullyReplicated
      r
    case software.amazon.awssdk.services.sagemaker.model.ProcessingS3DataDistributionType.SHARDED_BY_S3_KEY =>
      val r = ShardedByS3Key
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ProcessingS3DataDistributionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProcessingS3DataDistributionType =
      software.amazon.awssdk.services.sagemaker.model.ProcessingS3DataDistributionType.UNKNOWN_TO_SDK_VERSION
  }
  case object FullyReplicated
      extends zio.aws.sagemaker.model.ProcessingS3DataDistributionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProcessingS3DataDistributionType =
      software.amazon.awssdk.services.sagemaker.model.ProcessingS3DataDistributionType.FULLY_REPLICATED
  }
  case object ShardedByS3Key
      extends zio.aws.sagemaker.model.ProcessingS3DataDistributionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProcessingS3DataDistributionType =
      software.amazon.awssdk.services.sagemaker.model.ProcessingS3DataDistributionType.SHARDED_BY_S3_KEY
  }
}
