package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.MonitoringScheduleName
import scala.jdk.CollectionConverters.*
final case class CreateMonitoringScheduleRequest(
    monitoringScheduleName: MonitoringScheduleName,
    monitoringScheduleConfig: zio.aws.sagemaker.model.MonitoringScheduleConfig,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateMonitoringScheduleRequest = {
    import CreateMonitoringScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateMonitoringScheduleRequest
      .builder()
      .monitoringScheduleName(
        MonitoringScheduleName.unwrap(monitoringScheduleName): java.lang.String
      )
      .monitoringScheduleConfig(monitoringScheduleConfig.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateMonitoringScheduleRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateMonitoringScheduleRequest
      .wrap(buildAwsValue())
}
object CreateMonitoringScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateMonitoringScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateMonitoringScheduleRequest =
      zio.aws.sagemaker.model.CreateMonitoringScheduleRequest(
        monitoringScheduleName,
        monitoringScheduleConfig.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def monitoringScheduleName: MonitoringScheduleName
    def monitoringScheduleConfig
        : zio.aws.sagemaker.model.MonitoringScheduleConfig.ReadOnly
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getMonitoringScheduleName: ZIO[Any, Nothing, MonitoringScheduleName] =
      ZIO.succeed(monitoringScheduleName)
    def getMonitoringScheduleConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.MonitoringScheduleConfig.ReadOnly
    ] = ZIO.succeed(monitoringScheduleConfig)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateMonitoringScheduleRequest
  ) extends zio.aws.sagemaker.model.CreateMonitoringScheduleRequest.ReadOnly {
    override val monitoringScheduleName: MonitoringScheduleName =
      zio.aws.sagemaker.model.primitives
        .MonitoringScheduleName(impl.monitoringScheduleName())
    override val monitoringScheduleConfig
        : zio.aws.sagemaker.model.MonitoringScheduleConfig.ReadOnly =
      zio.aws.sagemaker.model.MonitoringScheduleConfig
        .wrap(impl.monitoringScheduleConfig())
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateMonitoringScheduleRequest
  ): zio.aws.sagemaker.model.CreateMonitoringScheduleRequest.ReadOnly =
    new Wrapper(impl)
}
