package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.MonitoringJobDefinitionArn
import scala.jdk.CollectionConverters.*
final case class CreateModelExplainabilityJobDefinitionResponse(
    jobDefinitionArn: MonitoringJobDefinitionArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateModelExplainabilityJobDefinitionResponse = {
    import CreateModelExplainabilityJobDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateModelExplainabilityJobDefinitionResponse
      .builder()
      .jobDefinitionArn(
        MonitoringJobDefinitionArn.unwrap(jobDefinitionArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateModelExplainabilityJobDefinitionResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateModelExplainabilityJobDefinitionResponse
      .wrap(buildAwsValue())
}
object CreateModelExplainabilityJobDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateModelExplainabilityJobDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.CreateModelExplainabilityJobDefinitionResponse =
      zio.aws.sagemaker.model
        .CreateModelExplainabilityJobDefinitionResponse(jobDefinitionArn)
    def jobDefinitionArn: MonitoringJobDefinitionArn
    def getJobDefinitionArn: ZIO[Any, Nothing, MonitoringJobDefinitionArn] =
      ZIO.succeed(jobDefinitionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelExplainabilityJobDefinitionResponse
  ) extends zio.aws.sagemaker.model.CreateModelExplainabilityJobDefinitionResponse.ReadOnly {
    override val jobDefinitionArn: MonitoringJobDefinitionArn =
      zio.aws.sagemaker.model.primitives
        .MonitoringJobDefinitionArn(impl.jobDefinitionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelExplainabilityJobDefinitionResponse
  ): zio.aws.sagemaker.model.CreateModelExplainabilityJobDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
