package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.MonitoringScheduleName
import scala.jdk.CollectionConverters.*
final case class UpdateMonitoringScheduleRequest(
    monitoringScheduleName: MonitoringScheduleName,
    monitoringScheduleConfig: zio.aws.sagemaker.model.MonitoringScheduleConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringScheduleRequest = {
    import UpdateMonitoringScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringScheduleRequest
      .builder()
      .monitoringScheduleName(
        MonitoringScheduleName.unwrap(monitoringScheduleName): java.lang.String
      )
      .monitoringScheduleConfig(monitoringScheduleConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.UpdateMonitoringScheduleRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateMonitoringScheduleRequest
      .wrap(buildAwsValue())
}
object UpdateMonitoringScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateMonitoringScheduleRequest =
      zio.aws.sagemaker.model.UpdateMonitoringScheduleRequest(
        monitoringScheduleName,
        monitoringScheduleConfig.asEditable
      )
    def monitoringScheduleName: MonitoringScheduleName
    def monitoringScheduleConfig
        : zio.aws.sagemaker.model.MonitoringScheduleConfig.ReadOnly
    def getMonitoringScheduleName: ZIO[Any, Nothing, MonitoringScheduleName] =
      ZIO.succeed(monitoringScheduleName)
    def getMonitoringScheduleConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.MonitoringScheduleConfig.ReadOnly
    ] = ZIO.succeed(monitoringScheduleConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringScheduleRequest
  ) extends zio.aws.sagemaker.model.UpdateMonitoringScheduleRequest.ReadOnly {
    override val monitoringScheduleName: MonitoringScheduleName =
      zio.aws.sagemaker.model.primitives
        .MonitoringScheduleName(impl.monitoringScheduleName())
    override val monitoringScheduleConfig
        : zio.aws.sagemaker.model.MonitoringScheduleConfig.ReadOnly =
      zio.aws.sagemaker.model.MonitoringScheduleConfig
        .wrap(impl.monitoringScheduleConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringScheduleRequest
  ): zio.aws.sagemaker.model.UpdateMonitoringScheduleRequest.ReadOnly =
    new Wrapper(impl)
}
