package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NotebookInstanceArn
import scala.jdk.CollectionConverters.*
final case class CreateNotebookInstanceResponse(
    notebookInstanceArn: Optional[NotebookInstanceArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceResponse = {
    import CreateNotebookInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceResponse
      .builder()
      .optionallyWith(
        notebookInstanceArn.map(value =>
          NotebookInstanceArn.unwrap(value): java.lang.String
        )
      )(_.notebookInstanceArn)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateNotebookInstanceResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateNotebookInstanceResponse.wrap(buildAwsValue())
}
object CreateNotebookInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateNotebookInstanceResponse =
      zio.aws.sagemaker.model
        .CreateNotebookInstanceResponse(notebookInstanceArn.map(value => value))
    def notebookInstanceArn: Optional[NotebookInstanceArn]
    def getNotebookInstanceArn: ZIO[Any, AwsError, NotebookInstanceArn] =
      AwsError.unwrapOptionField("notebookInstanceArn", notebookInstanceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceResponse
  ) extends zio.aws.sagemaker.model.CreateNotebookInstanceResponse.ReadOnly {
    override val notebookInstanceArn: Optional[NotebookInstanceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notebookInstanceArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.NotebookInstanceArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceResponse
  ): zio.aws.sagemaker.model.CreateNotebookInstanceResponse.ReadOnly =
    new Wrapper(impl)
}
