package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.NotebookInstanceName
import scala.jdk.CollectionConverters.*
final case class StopNotebookInstanceRequest(
    notebookInstanceName: NotebookInstanceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.StopNotebookInstanceRequest = {
    import StopNotebookInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.StopNotebookInstanceRequest
      .builder()
      .notebookInstanceName(
        NotebookInstanceName.unwrap(notebookInstanceName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.StopNotebookInstanceRequest.ReadOnly =
    zio.aws.sagemaker.model.StopNotebookInstanceRequest.wrap(buildAwsValue())
}
object StopNotebookInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.StopNotebookInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.StopNotebookInstanceRequest =
      zio.aws.sagemaker.model.StopNotebookInstanceRequest(notebookInstanceName)
    def notebookInstanceName: NotebookInstanceName
    def getNotebookInstanceName: ZIO[Any, Nothing, NotebookInstanceName] =
      ZIO.succeed(notebookInstanceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.StopNotebookInstanceRequest
  ) extends zio.aws.sagemaker.model.StopNotebookInstanceRequest.ReadOnly {
    override val notebookInstanceName: NotebookInstanceName =
      zio.aws.sagemaker.model.primitives
        .NotebookInstanceName(impl.notebookInstanceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.StopNotebookInstanceRequest
  ): zio.aws.sagemaker.model.StopNotebookInstanceRequest.ReadOnly = new Wrapper(
    impl
  )
}
