package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  TrafficDurationInSeconds,
  SpawnRate,
  InitialNumberOfUsers
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Phase(
    initialNumberOfUsers: Optional[InitialNumberOfUsers] = Optional.Absent,
    spawnRate: Optional[SpawnRate] = Optional.Absent,
    durationInSeconds: Optional[TrafficDurationInSeconds] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.sagemaker.model.Phase = {
    import Phase.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Phase
      .builder()
      .optionallyWith(
        initialNumberOfUsers.map(value =>
          InitialNumberOfUsers.unwrap(value): Integer
        )
      )(_.initialNumberOfUsers)
      .optionallyWith(spawnRate.map(value => SpawnRate.unwrap(value): Integer))(
        _.spawnRate
      )
      .optionallyWith(
        durationInSeconds.map(value =>
          TrafficDurationInSeconds.unwrap(value): Integer
        )
      )(_.durationInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Phase.ReadOnly =
    zio.aws.sagemaker.model.Phase.wrap(buildAwsValue())
}
object Phase {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sagemaker.model.Phase] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Phase =
      zio.aws.sagemaker.model.Phase(
        initialNumberOfUsers.map(value => value),
        spawnRate.map(value => value),
        durationInSeconds.map(value => value)
      )
    def initialNumberOfUsers: Optional[InitialNumberOfUsers]
    def spawnRate: Optional[SpawnRate]
    def durationInSeconds: Optional[TrafficDurationInSeconds]
    def getInitialNumberOfUsers: ZIO[Any, AwsError, InitialNumberOfUsers] =
      AwsError.unwrapOptionField("initialNumberOfUsers", initialNumberOfUsers)
    def getSpawnRate: ZIO[Any, AwsError, SpawnRate] =
      AwsError.unwrapOptionField("spawnRate", spawnRate)
    def getDurationInSeconds: ZIO[Any, AwsError, TrafficDurationInSeconds] =
      AwsError.unwrapOptionField("durationInSeconds", durationInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Phase
  ) extends zio.aws.sagemaker.model.Phase.ReadOnly {
    override val initialNumberOfUsers: Optional[InitialNumberOfUsers] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initialNumberOfUsers())
        .map(value =>
          zio.aws.sagemaker.model.primitives.InitialNumberOfUsers(value)
        )
    override val spawnRate: Optional[SpawnRate] = zio.aws.core.internal
      .optionalFromNullable(impl.spawnRate())
      .map(value => zio.aws.sagemaker.model.primitives.SpawnRate(value))
    override val durationInSeconds: Optional[TrafficDurationInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationInSeconds())
        .map(value =>
          zio.aws.sagemaker.model.primitives.TrafficDurationInSeconds(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Phase
  ): zio.aws.sagemaker.model.Phase.ReadOnly = new Wrapper(impl)
}
