package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  RoleArn,
  FeatureGroupArn,
  FailureReason,
  LastModifiedTime,
  FeatureGroupName,
  Description,
  FeatureName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class FeatureGroup(
    featureGroupArn: Optional[FeatureGroupArn] = Optional.Absent,
    featureGroupName: Optional[FeatureGroupName] = Optional.Absent,
    recordIdentifierFeatureName: Optional[FeatureName] = Optional.Absent,
    eventTimeFeatureName: Optional[FeatureName] = Optional.Absent,
    featureDefinitions: Optional[
      Iterable[zio.aws.sagemaker.model.FeatureDefinition]
    ] = Optional.Absent,
    creationTime: Optional[CreationTime] = Optional.Absent,
    lastModifiedTime: Optional[LastModifiedTime] = Optional.Absent,
    onlineStoreConfig: Optional[zio.aws.sagemaker.model.OnlineStoreConfig] =
      Optional.Absent,
    offlineStoreConfig: Optional[zio.aws.sagemaker.model.OfflineStoreConfig] =
      Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    featureGroupStatus: Optional[zio.aws.sagemaker.model.FeatureGroupStatus] =
      Optional.Absent,
    offlineStoreStatus: Optional[zio.aws.sagemaker.model.OfflineStoreStatus] =
      Optional.Absent,
    lastUpdateStatus: Optional[zio.aws.sagemaker.model.LastUpdateStatus] =
      Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.FeatureGroup = {
    import FeatureGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.FeatureGroup
      .builder()
      .optionallyWith(
        featureGroupArn.map(value =>
          FeatureGroupArn.unwrap(value): java.lang.String
        )
      )(_.featureGroupArn)
      .optionallyWith(
        featureGroupName.map(value =>
          FeatureGroupName.unwrap(value): java.lang.String
        )
      )(_.featureGroupName)
      .optionallyWith(
        recordIdentifierFeatureName.map(value =>
          FeatureName.unwrap(value): java.lang.String
        )
      )(_.recordIdentifierFeatureName)
      .optionallyWith(
        eventTimeFeatureName.map(value =>
          FeatureName.unwrap(value): java.lang.String
        )
      )(_.eventTimeFeatureName)
      .optionallyWith(
        featureDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.featureDefinitions)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => LastModifiedTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(onlineStoreConfig.map(value => value.buildAwsValue()))(
        _.onlineStoreConfig
      )
      .optionallyWith(offlineStoreConfig.map(value => value.buildAwsValue()))(
        _.offlineStoreConfig
      )
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(featureGroupStatus.map(value => value.unwrap))(
        _.featureGroupStatus
      )
      .optionallyWith(offlineStoreStatus.map(value => value.buildAwsValue()))(
        _.offlineStoreStatus
      )
      .optionallyWith(lastUpdateStatus.map(value => value.buildAwsValue()))(
        _.lastUpdateStatus
      )
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.FeatureGroup.ReadOnly =
    zio.aws.sagemaker.model.FeatureGroup.wrap(buildAwsValue())
}
object FeatureGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.FeatureGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.FeatureGroup =
      zio.aws.sagemaker.model.FeatureGroup(
        featureGroupArn.map(value => value),
        featureGroupName.map(value => value),
        recordIdentifierFeatureName.map(value => value),
        eventTimeFeatureName.map(value => value),
        featureDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        onlineStoreConfig.map(value => value.asEditable),
        offlineStoreConfig.map(value => value.asEditable),
        roleArn.map(value => value),
        featureGroupStatus.map(value => value),
        offlineStoreStatus.map(value => value.asEditable),
        lastUpdateStatus.map(value => value.asEditable),
        failureReason.map(value => value),
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def featureGroupArn: Optional[FeatureGroupArn]
    def featureGroupName: Optional[FeatureGroupName]
    def recordIdentifierFeatureName: Optional[FeatureName]
    def eventTimeFeatureName: Optional[FeatureName]
    def featureDefinitions
        : Optional[List[zio.aws.sagemaker.model.FeatureDefinition.ReadOnly]]
    def creationTime: Optional[CreationTime]
    def lastModifiedTime: Optional[LastModifiedTime]
    def onlineStoreConfig
        : Optional[zio.aws.sagemaker.model.OnlineStoreConfig.ReadOnly]
    def offlineStoreConfig
        : Optional[zio.aws.sagemaker.model.OfflineStoreConfig.ReadOnly]
    def roleArn: Optional[RoleArn]
    def featureGroupStatus: Optional[zio.aws.sagemaker.model.FeatureGroupStatus]
    def offlineStoreStatus
        : Optional[zio.aws.sagemaker.model.OfflineStoreStatus.ReadOnly]
    def lastUpdateStatus
        : Optional[zio.aws.sagemaker.model.LastUpdateStatus.ReadOnly]
    def failureReason: Optional[FailureReason]
    def description: Optional[Description]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getFeatureGroupArn: ZIO[Any, AwsError, FeatureGroupArn] =
      AwsError.unwrapOptionField("featureGroupArn", featureGroupArn)
    def getFeatureGroupName: ZIO[Any, AwsError, FeatureGroupName] =
      AwsError.unwrapOptionField("featureGroupName", featureGroupName)
    def getRecordIdentifierFeatureName: ZIO[Any, AwsError, FeatureName] =
      AwsError.unwrapOptionField(
        "recordIdentifierFeatureName",
        recordIdentifierFeatureName
      )
    def getEventTimeFeatureName: ZIO[Any, AwsError, FeatureName] =
      AwsError.unwrapOptionField("eventTimeFeatureName", eventTimeFeatureName)
    def getFeatureDefinitions: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.FeatureDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("featureDefinitions", featureDefinitions)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getOnlineStoreConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.OnlineStoreConfig.ReadOnly
    ] = AwsError.unwrapOptionField("onlineStoreConfig", onlineStoreConfig)
    def getOfflineStoreConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.OfflineStoreConfig.ReadOnly
    ] = AwsError.unwrapOptionField("offlineStoreConfig", offlineStoreConfig)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getFeatureGroupStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.FeatureGroupStatus] =
      AwsError.unwrapOptionField("featureGroupStatus", featureGroupStatus)
    def getOfflineStoreStatus: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.OfflineStoreStatus.ReadOnly
    ] = AwsError.unwrapOptionField("offlineStoreStatus", offlineStoreStatus)
    def getLastUpdateStatus: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.LastUpdateStatus.ReadOnly
    ] = AwsError.unwrapOptionField("lastUpdateStatus", lastUpdateStatus)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.FeatureGroup
  ) extends zio.aws.sagemaker.model.FeatureGroup.ReadOnly {
    override val featureGroupArn: Optional[FeatureGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureGroupArn())
        .map(value => zio.aws.sagemaker.model.primitives.FeatureGroupArn(value))
    override val featureGroupName: Optional[FeatureGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureGroupName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.FeatureGroupName(value)
        )
    override val recordIdentifierFeatureName: Optional[FeatureName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recordIdentifierFeatureName())
        .map(value => zio.aws.sagemaker.model.primitives.FeatureName(value))
    override val eventTimeFeatureName: Optional[FeatureName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventTimeFeatureName())
        .map(value => zio.aws.sagemaker.model.primitives.FeatureName(value))
    override val featureDefinitions
        : Optional[List[zio.aws.sagemaker.model.FeatureDefinition.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureDefinitions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.FeatureDefinition.wrap(item)
          }.toList
        )
    override val creationTime: Optional[CreationTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val lastModifiedTime: Optional[LastModifiedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTime())
        .map(value =>
          zio.aws.sagemaker.model.primitives.LastModifiedTime(value)
        )
    override val onlineStoreConfig
        : Optional[zio.aws.sagemaker.model.OnlineStoreConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onlineStoreConfig())
        .map(value => zio.aws.sagemaker.model.OnlineStoreConfig.wrap(value))
    override val offlineStoreConfig
        : Optional[zio.aws.sagemaker.model.OfflineStoreConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.offlineStoreConfig())
        .map(value => zio.aws.sagemaker.model.OfflineStoreConfig.wrap(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val featureGroupStatus
        : Optional[zio.aws.sagemaker.model.FeatureGroupStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureGroupStatus())
        .map(value => zio.aws.sagemaker.model.FeatureGroupStatus.wrap(value))
    override val offlineStoreStatus
        : Optional[zio.aws.sagemaker.model.OfflineStoreStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.offlineStoreStatus())
        .map(value => zio.aws.sagemaker.model.OfflineStoreStatus.wrap(value))
    override val lastUpdateStatus
        : Optional[zio.aws.sagemaker.model.LastUpdateStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdateStatus())
        .map(value => zio.aws.sagemaker.model.LastUpdateStatus.wrap(value))
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.sagemaker.model.primitives.Description(value))
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.FeatureGroup
  ): zio.aws.sagemaker.model.FeatureGroup.ReadOnly = new Wrapper(impl)
}
