package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.EdgePresetDeploymentArtifact
import scala.jdk.CollectionConverters.*
final case class EdgePresetDeploymentOutput(
    `type`: zio.aws.sagemaker.model.EdgePresetDeploymentType,
    artifact: Optional[EdgePresetDeploymentArtifact] = Optional.Absent,
    status: Optional[zio.aws.sagemaker.model.EdgePresetDeploymentStatus] =
      Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.EdgePresetDeploymentOutput = {
    import EdgePresetDeploymentOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.EdgePresetDeploymentOutput
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(
        artifact.map(value =>
          EdgePresetDeploymentArtifact.unwrap(value): java.lang.String
        )
      )(_.artifact)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.EdgePresetDeploymentOutput.ReadOnly =
    zio.aws.sagemaker.model.EdgePresetDeploymentOutput.wrap(buildAwsValue())
}
object EdgePresetDeploymentOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.EdgePresetDeploymentOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.EdgePresetDeploymentOutput =
      zio.aws.sagemaker.model.EdgePresetDeploymentOutput(
        `type`,
        artifact.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value)
      )
    def `type`: zio.aws.sagemaker.model.EdgePresetDeploymentType
    def artifact: Optional[EdgePresetDeploymentArtifact]
    def status: Optional[zio.aws.sagemaker.model.EdgePresetDeploymentStatus]
    def statusMessage: Optional[String]
    def getType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.EdgePresetDeploymentType] =
      ZIO.succeed(`type`)
    def getArtifact: ZIO[Any, AwsError, EdgePresetDeploymentArtifact] =
      AwsError.unwrapOptionField("artifact", artifact)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.EdgePresetDeploymentStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.EdgePresetDeploymentOutput
  ) extends zio.aws.sagemaker.model.EdgePresetDeploymentOutput.ReadOnly {
    override val `type`: zio.aws.sagemaker.model.EdgePresetDeploymentType =
      zio.aws.sagemaker.model.EdgePresetDeploymentType.wrap(impl.`type`())
    override val artifact: Optional[EdgePresetDeploymentArtifact] =
      zio.aws.core.internal
        .optionalFromNullable(impl.artifact())
        .map(value =>
          zio.aws.sagemaker.model.primitives.EdgePresetDeploymentArtifact(value)
        )
    override val status
        : Optional[zio.aws.sagemaker.model.EdgePresetDeploymentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.sagemaker.model.EdgePresetDeploymentStatus.wrap(value)
        )
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.EdgePresetDeploymentOutput
  ): zio.aws.sagemaker.model.EdgePresetDeploymentOutput.ReadOnly = new Wrapper(
    impl
  )
}
