package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters.*
final case class DeploymentStage(
    stageName: EntityName,
    deviceSelectionConfig: zio.aws.sagemaker.model.DeviceSelectionConfig,
    deploymentConfig: Optional[zio.aws.sagemaker.model.EdgeDeploymentConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeploymentStage = {
    import DeploymentStage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeploymentStage
      .builder()
      .stageName(EntityName.unwrap(stageName): java.lang.String)
      .deviceSelectionConfig(deviceSelectionConfig.buildAwsValue())
      .optionallyWith(deploymentConfig.map(value => value.buildAwsValue()))(
        _.deploymentConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeploymentStage.ReadOnly =
    zio.aws.sagemaker.model.DeploymentStage.wrap(buildAwsValue())
}
object DeploymentStage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeploymentStage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeploymentStage =
      zio.aws.sagemaker.model.DeploymentStage(
        stageName,
        deviceSelectionConfig.asEditable,
        deploymentConfig.map(value => value.asEditable)
      )
    def stageName: EntityName
    def deviceSelectionConfig
        : zio.aws.sagemaker.model.DeviceSelectionConfig.ReadOnly
    def deploymentConfig
        : Optional[zio.aws.sagemaker.model.EdgeDeploymentConfig.ReadOnly]
    def getStageName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(stageName)
    def getDeviceSelectionConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.DeviceSelectionConfig.ReadOnly
    ] = ZIO.succeed(deviceSelectionConfig)
    def getDeploymentConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.EdgeDeploymentConfig.ReadOnly
    ] = AwsError.unwrapOptionField("deploymentConfig", deploymentConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeploymentStage
  ) extends zio.aws.sagemaker.model.DeploymentStage.ReadOnly {
    override val stageName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.stageName())
    override val deviceSelectionConfig
        : zio.aws.sagemaker.model.DeviceSelectionConfig.ReadOnly =
      zio.aws.sagemaker.model.DeviceSelectionConfig
        .wrap(impl.deviceSelectionConfig())
    override val deploymentConfig
        : Optional[zio.aws.sagemaker.model.EdgeDeploymentConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentConfig())
        .map(value => zio.aws.sagemaker.model.EdgeDeploymentConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeploymentStage
  ): zio.aws.sagemaker.model.DeploymentStage.ReadOnly = new Wrapper(impl)
}
