package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  StepDisplayName,
  Timestamp,
  FailureReason,
  StepName,
  StepDescription,
  IntegerValue
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class PipelineExecutionStep(
    stepName: Optional[StepName] = Optional.Absent,
    stepDisplayName: Optional[StepDisplayName] = Optional.Absent,
    stepDescription: Optional[StepDescription] = Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    stepStatus: Optional[zio.aws.sagemaker.model.StepStatus] = Optional.Absent,
    cacheHitResult: Optional[zio.aws.sagemaker.model.CacheHitResult] =
      Optional.Absent,
    attemptCount: Optional[IntegerValue] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    metadata: Optional[zio.aws.sagemaker.model.PipelineExecutionStepMetadata] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStep = {
    import PipelineExecutionStep.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStep
      .builder()
      .optionallyWith(
        stepName.map(value => StepName.unwrap(value): java.lang.String)
      )(_.stepName)
      .optionallyWith(
        stepDisplayName.map(value =>
          StepDisplayName.unwrap(value): java.lang.String
        )
      )(_.stepDisplayName)
      .optionallyWith(
        stepDescription.map(value =>
          StepDescription.unwrap(value): java.lang.String
        )
      )(_.stepDescription)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(stepStatus.map(value => value.unwrap))(_.stepStatus)
      .optionallyWith(cacheHitResult.map(value => value.buildAwsValue()))(
        _.cacheHitResult
      )
      .optionallyWith(attemptCount.map(value => value: Integer))(_.attemptCount)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(metadata.map(value => value.buildAwsValue()))(_.metadata)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.PipelineExecutionStep.ReadOnly =
    zio.aws.sagemaker.model.PipelineExecutionStep.wrap(buildAwsValue())
}
object PipelineExecutionStep {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStep
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.PipelineExecutionStep =
      zio.aws.sagemaker.model.PipelineExecutionStep(
        stepName.map(value => value),
        stepDisplayName.map(value => value),
        stepDescription.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        stepStatus.map(value => value),
        cacheHitResult.map(value => value.asEditable),
        attemptCount.map(value => value),
        failureReason.map(value => value),
        metadata.map(value => value.asEditable)
      )
    def stepName: Optional[StepName]
    def stepDisplayName: Optional[StepDisplayName]
    def stepDescription: Optional[StepDescription]
    def startTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def stepStatus: Optional[zio.aws.sagemaker.model.StepStatus]
    def cacheHitResult
        : Optional[zio.aws.sagemaker.model.CacheHitResult.ReadOnly]
    def attemptCount: Optional[IntegerValue]
    def failureReason: Optional[FailureReason]
    def metadata: Optional[
      zio.aws.sagemaker.model.PipelineExecutionStepMetadata.ReadOnly
    ]
    def getStepName: ZIO[Any, AwsError, StepName] =
      AwsError.unwrapOptionField("stepName", stepName)
    def getStepDisplayName: ZIO[Any, AwsError, StepDisplayName] =
      AwsError.unwrapOptionField("stepDisplayName", stepDisplayName)
    def getStepDescription: ZIO[Any, AwsError, StepDescription] =
      AwsError.unwrapOptionField("stepDescription", stepDescription)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getStepStatus: ZIO[Any, AwsError, zio.aws.sagemaker.model.StepStatus] =
      AwsError.unwrapOptionField("stepStatus", stepStatus)
    def getCacheHitResult
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.CacheHitResult.ReadOnly] =
      AwsError.unwrapOptionField("cacheHitResult", cacheHitResult)
    def getAttemptCount: ZIO[Any, AwsError, IntegerValue] =
      AwsError.unwrapOptionField("attemptCount", attemptCount)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.PipelineExecutionStepMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("metadata", metadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStep
  ) extends zio.aws.sagemaker.model.PipelineExecutionStep.ReadOnly {
    override val stepName: Optional[StepName] = zio.aws.core.internal
      .optionalFromNullable(impl.stepName())
      .map(value => zio.aws.sagemaker.model.primitives.StepName(value))
    override val stepDisplayName: Optional[StepDisplayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepDisplayName())
        .map(value => zio.aws.sagemaker.model.primitives.StepDisplayName(value))
    override val stepDescription: Optional[StepDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepDescription())
        .map(value => zio.aws.sagemaker.model.primitives.StepDescription(value))
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val stepStatus: Optional[zio.aws.sagemaker.model.StepStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepStatus())
        .map(value => zio.aws.sagemaker.model.StepStatus.wrap(value))
    override val cacheHitResult
        : Optional[zio.aws.sagemaker.model.CacheHitResult.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheHitResult())
        .map(value => zio.aws.sagemaker.model.CacheHitResult.wrap(value))
    override val attemptCount: Optional[IntegerValue] = zio.aws.core.internal
      .optionalFromNullable(impl.attemptCount())
      .map(value => value: IntegerValue)
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val metadata: Optional[
      zio.aws.sagemaker.model.PipelineExecutionStepMetadata.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value =>
        zio.aws.sagemaker.model.PipelineExecutionStepMetadata.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStep
  ): zio.aws.sagemaker.model.PipelineExecutionStep.ReadOnly = new Wrapper(impl)
}
