package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class MonitoringOutput(
    s3Output: zio.aws.sagemaker.model.MonitoringS3Output
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MonitoringOutput = {
    import MonitoringOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MonitoringOutput
      .builder()
      .s3Output(s3Output.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MonitoringOutput.ReadOnly =
    zio.aws.sagemaker.model.MonitoringOutput.wrap(buildAwsValue())
}
object MonitoringOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MonitoringOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MonitoringOutput =
      zio.aws.sagemaker.model.MonitoringOutput(s3Output.asEditable)
    def s3Output: zio.aws.sagemaker.model.MonitoringS3Output.ReadOnly
    def getS3Output: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.MonitoringS3Output.ReadOnly
    ] = ZIO.succeed(s3Output)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringOutput
  ) extends zio.aws.sagemaker.model.MonitoringOutput.ReadOnly {
    override val s3Output: zio.aws.sagemaker.model.MonitoringS3Output.ReadOnly =
      zio.aws.sagemaker.model.MonitoringS3Output.wrap(impl.s3Output())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringOutput
  ): zio.aws.sagemaker.model.MonitoringOutput.ReadOnly = new Wrapper(impl)
}
