package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{MaxResults, NextToken, WorkteamName}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListWorkteamsRequest(
    sortBy: Optional[zio.aws.sagemaker.model.ListWorkteamsSortByOptions] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] = Optional.Absent,
    nameContains: Optional[WorkteamName] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest = {
    import ListWorkteamsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest
      .builder()
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nameContains.map(value => WorkteamName.unwrap(value): java.lang.String)
      )(_.nameContains)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListWorkteamsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListWorkteamsRequest.wrap(buildAwsValue())
}
object ListWorkteamsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListWorkteamsRequest =
      zio.aws.sagemaker.model.ListWorkteamsRequest(
        sortBy.map(value => value),
        sortOrder.map(value => value),
        nameContains.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def sortBy: Optional[zio.aws.sagemaker.model.ListWorkteamsSortByOptions]
    def sortOrder: Optional[zio.aws.sagemaker.model.SortOrder]
    def nameContains: Optional[WorkteamName]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ListWorkteamsSortByOptions
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNameContains: ZIO[Any, AwsError, WorkteamName] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest
  ) extends zio.aws.sagemaker.model.ListWorkteamsRequest.ReadOnly {
    override val sortBy
        : Optional[zio.aws.sagemaker.model.ListWorkteamsSortByOptions] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value =>
          zio.aws.sagemaker.model.ListWorkteamsSortByOptions.wrap(value)
        )
    override val sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
    override val nameContains: Optional[WorkteamName] = zio.aws.core.internal
      .optionalFromNullable(impl.nameContains())
      .map(value => zio.aws.sagemaker.model.primitives.WorkteamName(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest
  ): zio.aws.sagemaker.model.ListWorkteamsRequest.ReadOnly = new Wrapper(impl)
}
