package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.WorkforceName
import scala.jdk.CollectionConverters.*
final case class DeleteWorkforceRequest(workforceName: WorkforceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteWorkforceRequest = {
    import DeleteWorkforceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteWorkforceRequest
      .builder()
      .workforceName(WorkforceName.unwrap(workforceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteWorkforceRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteWorkforceRequest.wrap(buildAwsValue())
}
object DeleteWorkforceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteWorkforceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteWorkforceRequest =
      zio.aws.sagemaker.model.DeleteWorkforceRequest(workforceName)
    def workforceName: WorkforceName
    def getWorkforceName: ZIO[Any, Nothing, WorkforceName] =
      ZIO.succeed(workforceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteWorkforceRequest
  ) extends zio.aws.sagemaker.model.DeleteWorkforceRequest.ReadOnly {
    override val workforceName: WorkforceName =
      zio.aws.sagemaker.model.primitives.WorkforceName(impl.workforceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteWorkforceRequest
  ): zio.aws.sagemaker.model.DeleteWorkforceRequest.ReadOnly = new Wrapper(impl)
}
