package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.CodeRepositoryArn
import scala.jdk.CollectionConverters.*
final case class CreateCodeRepositoryResponse(
    codeRepositoryArn: CodeRepositoryArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateCodeRepositoryResponse = {
    import CreateCodeRepositoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateCodeRepositoryResponse
      .builder()
      .codeRepositoryArn(
        CodeRepositoryArn.unwrap(codeRepositoryArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateCodeRepositoryResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateCodeRepositoryResponse.wrap(buildAwsValue())
}
object CreateCodeRepositoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateCodeRepositoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateCodeRepositoryResponse =
      zio.aws.sagemaker.model.CreateCodeRepositoryResponse(codeRepositoryArn)
    def codeRepositoryArn: CodeRepositoryArn
    def getCodeRepositoryArn: ZIO[Any, Nothing, CodeRepositoryArn] =
      ZIO.succeed(codeRepositoryArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateCodeRepositoryResponse
  ) extends zio.aws.sagemaker.model.CreateCodeRepositoryResponse.ReadOnly {
    override val codeRepositoryArn: CodeRepositoryArn =
      zio.aws.sagemaker.model.primitives
        .CodeRepositoryArn(impl.codeRepositoryArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateCodeRepositoryResponse
  ): zio.aws.sagemaker.model.CreateCodeRepositoryResponse.ReadOnly =
    new Wrapper(impl)
}
