package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  ExperimentEntityName,
  String256,
  AssociationEntityArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class AssociationSummary(
    sourceArn: Optional[AssociationEntityArn] = Optional.Absent,
    destinationArn: Optional[AssociationEntityArn] = Optional.Absent,
    sourceType: Optional[String256] = Optional.Absent,
    destinationType: Optional[String256] = Optional.Absent,
    associationType: Optional[zio.aws.sagemaker.model.AssociationEdgeType] =
      Optional.Absent,
    sourceName: Optional[ExperimentEntityName] = Optional.Absent,
    destinationName: Optional[ExperimentEntityName] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    createdBy: Optional[zio.aws.sagemaker.model.UserContext] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AssociationSummary = {
    import AssociationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AssociationSummary
      .builder()
      .optionallyWith(
        sourceArn.map(value =>
          AssociationEntityArn.unwrap(value): java.lang.String
        )
      )(_.sourceArn)
      .optionallyWith(
        destinationArn.map(value =>
          AssociationEntityArn.unwrap(value): java.lang.String
        )
      )(_.destinationArn)
      .optionallyWith(
        sourceType.map(value => String256.unwrap(value): java.lang.String)
      )(_.sourceType)
      .optionallyWith(
        destinationType.map(value => String256.unwrap(value): java.lang.String)
      )(_.destinationType)
      .optionallyWith(associationType.map(value => value.unwrap))(
        _.associationType
      )
      .optionallyWith(
        sourceName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.sourceName)
      .optionallyWith(
        destinationName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.destinationName)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AssociationSummary.ReadOnly =
    zio.aws.sagemaker.model.AssociationSummary.wrap(buildAwsValue())
}
object AssociationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AssociationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AssociationSummary =
      zio.aws.sagemaker.model.AssociationSummary(
        sourceArn.map(value => value),
        destinationArn.map(value => value),
        sourceType.map(value => value),
        destinationType.map(value => value),
        associationType.map(value => value),
        sourceName.map(value => value),
        destinationName.map(value => value),
        creationTime.map(value => value),
        createdBy.map(value => value.asEditable)
      )
    def sourceArn: Optional[AssociationEntityArn]
    def destinationArn: Optional[AssociationEntityArn]
    def sourceType: Optional[String256]
    def destinationType: Optional[String256]
    def associationType: Optional[zio.aws.sagemaker.model.AssociationEdgeType]
    def sourceName: Optional[ExperimentEntityName]
    def destinationName: Optional[ExperimentEntityName]
    def creationTime: Optional[Timestamp]
    def createdBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def getSourceArn: ZIO[Any, AwsError, AssociationEntityArn] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getDestinationArn: ZIO[Any, AwsError, AssociationEntityArn] =
      AwsError.unwrapOptionField("destinationArn", destinationArn)
    def getSourceType: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getDestinationType: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("destinationType", destinationType)
    def getAssociationType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.AssociationEdgeType] =
      AwsError.unwrapOptionField("associationType", associationType)
    def getSourceName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("sourceName", sourceName)
    def getDestinationName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("destinationName", destinationName)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AssociationSummary
  ) extends zio.aws.sagemaker.model.AssociationSummary.ReadOnly {
    override val sourceArn: Optional[AssociationEntityArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.AssociationEntityArn(value)
        )
    override val destinationArn: Optional[AssociationEntityArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.AssociationEntityArn(value)
        )
    override val sourceType: Optional[String256] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceType())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val destinationType: Optional[String256] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationType())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val associationType
        : Optional[zio.aws.sagemaker.model.AssociationEdgeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationType())
        .map(value => zio.aws.sagemaker.model.AssociationEdgeType.wrap(value))
    override val sourceName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val destinationName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AssociationSummary
  ): zio.aws.sagemaker.model.AssociationSummary.ReadOnly = new Wrapper(impl)
}
