package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{ArnOrName, AlgorithmImage}
import scala.jdk.CollectionConverters.*
final case class AlgorithmSpecification(
    trainingImage: Optional[AlgorithmImage] = Optional.Absent,
    algorithmName: Optional[ArnOrName] = Optional.Absent,
    trainingInputMode: zio.aws.sagemaker.model.TrainingInputMode,
    metricDefinitions: Optional[
      Iterable[zio.aws.sagemaker.model.MetricDefinition]
    ] = Optional.Absent,
    enableSageMakerMetricsTimeSeries: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AlgorithmSpecification = {
    import AlgorithmSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AlgorithmSpecification
      .builder()
      .optionallyWith(
        trainingImage.map(value =>
          AlgorithmImage.unwrap(value): java.lang.String
        )
      )(_.trainingImage)
      .optionallyWith(
        algorithmName.map(value => ArnOrName.unwrap(value): java.lang.String)
      )(_.algorithmName)
      .trainingInputMode(trainingInputMode.unwrap)
      .optionallyWith(
        metricDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricDefinitions)
      .optionallyWith(
        enableSageMakerMetricsTimeSeries.map(value => value: java.lang.Boolean)
      )(_.enableSageMakerMetricsTimeSeries)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AlgorithmSpecification.ReadOnly =
    zio.aws.sagemaker.model.AlgorithmSpecification.wrap(buildAwsValue())
}
object AlgorithmSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AlgorithmSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AlgorithmSpecification =
      zio.aws.sagemaker.model.AlgorithmSpecification(
        trainingImage.map(value => value),
        algorithmName.map(value => value),
        trainingInputMode,
        metricDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        enableSageMakerMetricsTimeSeries.map(value => value)
      )
    def trainingImage: Optional[AlgorithmImage]
    def algorithmName: Optional[ArnOrName]
    def trainingInputMode: zio.aws.sagemaker.model.TrainingInputMode
    def metricDefinitions
        : Optional[List[zio.aws.sagemaker.model.MetricDefinition.ReadOnly]]
    def enableSageMakerMetricsTimeSeries: Optional[Boolean]
    def getTrainingImage: ZIO[Any, AwsError, AlgorithmImage] =
      AwsError.unwrapOptionField("trainingImage", trainingImage)
    def getAlgorithmName: ZIO[Any, AwsError, ArnOrName] =
      AwsError.unwrapOptionField("algorithmName", algorithmName)
    def getTrainingInputMode
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.TrainingInputMode] =
      ZIO.succeed(trainingInputMode)
    def getMetricDefinitions: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.MetricDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("metricDefinitions", metricDefinitions)
    def getEnableSageMakerMetricsTimeSeries: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableSageMakerMetricsTimeSeries",
        enableSageMakerMetricsTimeSeries
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AlgorithmSpecification
  ) extends zio.aws.sagemaker.model.AlgorithmSpecification.ReadOnly {
    override val trainingImage: Optional[AlgorithmImage] = zio.aws.core.internal
      .optionalFromNullable(impl.trainingImage())
      .map(value => zio.aws.sagemaker.model.primitives.AlgorithmImage(value))
    override val algorithmName: Optional[ArnOrName] = zio.aws.core.internal
      .optionalFromNullable(impl.algorithmName())
      .map(value => zio.aws.sagemaker.model.primitives.ArnOrName(value))
    override val trainingInputMode: zio.aws.sagemaker.model.TrainingInputMode =
      zio.aws.sagemaker.model.TrainingInputMode.wrap(impl.trainingInputMode())
    override val metricDefinitions
        : Optional[List[zio.aws.sagemaker.model.MetricDefinition.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricDefinitions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.MetricDefinition.wrap(item)
          }.toList
        )
    override val enableSageMakerMetricsTimeSeries: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableSageMakerMetricsTimeSeries())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AlgorithmSpecification
  ): zio.aws.sagemaker.model.AlgorithmSpecification.ReadOnly = new Wrapper(impl)
}
