package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.RepositoryCredentialsProviderArn
import scala.jdk.CollectionConverters.*
final case class RepositoryAuthConfig(
    repositoryCredentialsProviderArn: RepositoryCredentialsProviderArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RepositoryAuthConfig = {
    import RepositoryAuthConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RepositoryAuthConfig
      .builder()
      .repositoryCredentialsProviderArn(
        RepositoryCredentialsProviderArn.unwrap(
          repositoryCredentialsProviderArn
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.RepositoryAuthConfig.ReadOnly =
    zio.aws.sagemaker.model.RepositoryAuthConfig.wrap(buildAwsValue())
}
object RepositoryAuthConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RepositoryAuthConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RepositoryAuthConfig =
      zio.aws.sagemaker.model
        .RepositoryAuthConfig(repositoryCredentialsProviderArn)
    def repositoryCredentialsProviderArn: RepositoryCredentialsProviderArn
    def getRepositoryCredentialsProviderArn
        : ZIO[Any, Nothing, RepositoryCredentialsProviderArn] =
      ZIO.succeed(repositoryCredentialsProviderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RepositoryAuthConfig
  ) extends zio.aws.sagemaker.model.RepositoryAuthConfig.ReadOnly {
    override val repositoryCredentialsProviderArn
        : RepositoryCredentialsProviderArn = zio.aws.sagemaker.model.primitives
      .RepositoryCredentialsProviderArn(impl.repositoryCredentialsProviderArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RepositoryAuthConfig
  ): zio.aws.sagemaker.model.RepositoryAuthConfig.ReadOnly = new Wrapper(impl)
}
