package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ExperimentEntityName
import scala.jdk.CollectionConverters.*
final case class DescribeTrialRequest(trialName: ExperimentEntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeTrialRequest = {
    import DescribeTrialRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeTrialRequest
      .builder()
      .trialName(ExperimentEntityName.unwrap(trialName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeTrialRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeTrialRequest.wrap(buildAwsValue())
}
object DescribeTrialRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeTrialRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeTrialRequest =
      zio.aws.sagemaker.model.DescribeTrialRequest(trialName)
    def trialName: ExperimentEntityName
    def getTrialName: ZIO[Any, Nothing, ExperimentEntityName] =
      ZIO.succeed(trialName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeTrialRequest
  ) extends zio.aws.sagemaker.model.DescribeTrialRequest.ReadOnly {
    override val trialName: ExperimentEntityName =
      zio.aws.sagemaker.model.primitives.ExperimentEntityName(impl.trialName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeTrialRequest
  ): zio.aws.sagemaker.model.DescribeTrialRequest.ReadOnly = new Wrapper(impl)
}
