package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NotebookInstanceLifecycleConfigArn
import scala.jdk.CollectionConverters.*
final case class CreateNotebookInstanceLifecycleConfigResponse(
    notebookInstanceLifecycleConfigArn: Optional[
      NotebookInstanceLifecycleConfigArn
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceLifecycleConfigResponse = {
    import CreateNotebookInstanceLifecycleConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceLifecycleConfigResponse
      .builder()
      .optionallyWith(
        notebookInstanceLifecycleConfigArn.map(value =>
          NotebookInstanceLifecycleConfigArn.unwrap(value): java.lang.String
        )
      )(_.notebookInstanceLifecycleConfigArn)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateNotebookInstanceLifecycleConfigResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateNotebookInstanceLifecycleConfigResponse
      .wrap(buildAwsValue())
}
object CreateNotebookInstanceLifecycleConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceLifecycleConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.CreateNotebookInstanceLifecycleConfigResponse =
      zio.aws.sagemaker.model.CreateNotebookInstanceLifecycleConfigResponse(
        notebookInstanceLifecycleConfigArn.map(value => value)
      )
    def notebookInstanceLifecycleConfigArn
        : Optional[NotebookInstanceLifecycleConfigArn]
    def getNotebookInstanceLifecycleConfigArn
        : ZIO[Any, AwsError, NotebookInstanceLifecycleConfigArn] =
      AwsError.unwrapOptionField(
        "notebookInstanceLifecycleConfigArn",
        notebookInstanceLifecycleConfigArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceLifecycleConfigResponse
  ) extends zio.aws.sagemaker.model.CreateNotebookInstanceLifecycleConfigResponse.ReadOnly {
    override val notebookInstanceLifecycleConfigArn
        : Optional[NotebookInstanceLifecycleConfigArn] = zio.aws.core.internal
      .optionalFromNullable(impl.notebookInstanceLifecycleConfigArn())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .NotebookInstanceLifecycleConfigArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceLifecycleConfigResponse
  ): zio.aws.sagemaker.model.CreateNotebookInstanceLifecycleConfigResponse.ReadOnly =
    new Wrapper(impl)
}
