package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters.*
final case class StopCompilationJobRequest(compilationJobName: EntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.StopCompilationJobRequest = {
    import StopCompilationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.StopCompilationJobRequest
      .builder()
      .compilationJobName(
        EntityName.unwrap(compilationJobName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.StopCompilationJobRequest.ReadOnly =
    zio.aws.sagemaker.model.StopCompilationJobRequest.wrap(buildAwsValue())
}
object StopCompilationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.StopCompilationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.StopCompilationJobRequest =
      zio.aws.sagemaker.model.StopCompilationJobRequest(compilationJobName)
    def compilationJobName: EntityName
    def getCompilationJobName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(compilationJobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.StopCompilationJobRequest
  ) extends zio.aws.sagemaker.model.StopCompilationJobRequest.ReadOnly {
    override val compilationJobName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.compilationJobName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.StopCompilationJobRequest
  ): zio.aws.sagemaker.model.StopCompilationJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
