package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  ProcessingEnvironmentValue,
  ProcessingEnvironmentKey,
  S3Uri,
  ImageUri
}
import scala.jdk.CollectionConverters.*
final case class ModelExplainabilityAppSpecification(
    imageUri: ImageUri,
    configUri: S3Uri,
    environment: Optional[
      Map[ProcessingEnvironmentKey, ProcessingEnvironmentValue]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelExplainabilityAppSpecification = {
    import ModelExplainabilityAppSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelExplainabilityAppSpecification
      .builder()
      .imageUri(ImageUri.unwrap(imageUri): java.lang.String)
      .configUri(S3Uri.unwrap(configUri): java.lang.String)
      .optionallyWith(
        environment.map(value =>
          value
            .map({ case (key, value) =>
              (ProcessingEnvironmentKey
                .unwrap(key): java.lang.String) -> (ProcessingEnvironmentValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.environment)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ModelExplainabilityAppSpecification.ReadOnly =
    zio.aws.sagemaker.model.ModelExplainabilityAppSpecification
      .wrap(buildAwsValue())
}
object ModelExplainabilityAppSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelExplainabilityAppSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.ModelExplainabilityAppSpecification =
      zio.aws.sagemaker.model.ModelExplainabilityAppSpecification(
        imageUri,
        configUri,
        environment.map(value => value)
      )
    def imageUri: ImageUri
    def configUri: S3Uri
    def environment
        : Optional[Map[ProcessingEnvironmentKey, ProcessingEnvironmentValue]]
    def getImageUri: ZIO[Any, Nothing, ImageUri] = ZIO.succeed(imageUri)
    def getConfigUri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(configUri)
    def getEnvironment: ZIO[Any, AwsError, Map[
      ProcessingEnvironmentKey,
      ProcessingEnvironmentValue
    ]] = AwsError.unwrapOptionField("environment", environment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelExplainabilityAppSpecification
  ) extends zio.aws.sagemaker.model.ModelExplainabilityAppSpecification.ReadOnly {
    override val imageUri: ImageUri =
      zio.aws.sagemaker.model.primitives.ImageUri(impl.imageUri())
    override val configUri: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.configUri())
    override val environment
        : Optional[Map[ProcessingEnvironmentKey, ProcessingEnvironmentValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.ProcessingEnvironmentKey(
                key
              ) -> zio.aws.sagemaker.model.primitives
                .ProcessingEnvironmentValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelExplainabilityAppSpecification
  ): zio.aws.sagemaker.model.ModelExplainabilityAppSpecification.ReadOnly =
    new Wrapper(impl)
}
