package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  EndpointConfigArn,
  EndpointConfigName
}
import scala.jdk.CollectionConverters.*
final case class EndpointConfigSummary(
    endpointConfigName: EndpointConfigName,
    endpointConfigArn: EndpointConfigArn,
    creationTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.EndpointConfigSummary = {
    import EndpointConfigSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.EndpointConfigSummary
      .builder()
      .endpointConfigName(
        EndpointConfigName.unwrap(endpointConfigName): java.lang.String
      )
      .endpointConfigArn(
        EndpointConfigArn.unwrap(endpointConfigArn): java.lang.String
      )
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.EndpointConfigSummary.ReadOnly =
    zio.aws.sagemaker.model.EndpointConfigSummary.wrap(buildAwsValue())
}
object EndpointConfigSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.EndpointConfigSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.EndpointConfigSummary =
      zio.aws.sagemaker.model.EndpointConfigSummary(
        endpointConfigName,
        endpointConfigArn,
        creationTime
      )
    def endpointConfigName: EndpointConfigName
    def endpointConfigArn: EndpointConfigArn
    def creationTime: Timestamp
    def getEndpointConfigName: ZIO[Any, Nothing, EndpointConfigName] =
      ZIO.succeed(endpointConfigName)
    def getEndpointConfigArn: ZIO[Any, Nothing, EndpointConfigArn] =
      ZIO.succeed(endpointConfigArn)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.EndpointConfigSummary
  ) extends zio.aws.sagemaker.model.EndpointConfigSummary.ReadOnly {
    override val endpointConfigName: EndpointConfigName =
      zio.aws.sagemaker.model.primitives
        .EndpointConfigName(impl.endpointConfigName())
    override val endpointConfigArn: EndpointConfigArn =
      zio.aws.sagemaker.model.primitives
        .EndpointConfigArn(impl.endpointConfigArn())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.EndpointConfigSummary
  ): zio.aws.sagemaker.model.EndpointConfigSummary.ReadOnly = new Wrapper(impl)
}
