package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.VersionedArnOrName
import scala.jdk.CollectionConverters.*
final case class DescribeModelPackageRequest(
    modelPackageName: VersionedArnOrName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageRequest = {
    import DescribeModelPackageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageRequest
      .builder()
      .modelPackageName(
        VersionedArnOrName.unwrap(modelPackageName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeModelPackageRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeModelPackageRequest.wrap(buildAwsValue())
}
object DescribeModelPackageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeModelPackageRequest =
      zio.aws.sagemaker.model.DescribeModelPackageRequest(modelPackageName)
    def modelPackageName: VersionedArnOrName
    def getModelPackageName: ZIO[Any, Nothing, VersionedArnOrName] =
      ZIO.succeed(modelPackageName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageRequest
  ) extends zio.aws.sagemaker.model.DescribeModelPackageRequest.ReadOnly {
    override val modelPackageName: VersionedArnOrName =
      zio.aws.sagemaker.model.primitives
        .VersionedArnOrName(impl.modelPackageName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageRequest
  ): zio.aws.sagemaker.model.DescribeModelPackageRequest.ReadOnly = new Wrapper(
    impl
  )
}
