package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  HumanTaskUiName,
  HumanTaskUiArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeHumanTaskUiResponse(
    humanTaskUiArn: HumanTaskUiArn,
    humanTaskUiName: HumanTaskUiName,
    humanTaskUiStatus: Optional[zio.aws.sagemaker.model.HumanTaskUiStatus] =
      Optional.Absent,
    creationTime: Timestamp,
    uiTemplate: zio.aws.sagemaker.model.UiTemplateInfo
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeHumanTaskUiResponse = {
    import DescribeHumanTaskUiResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeHumanTaskUiResponse
      .builder()
      .humanTaskUiArn(HumanTaskUiArn.unwrap(humanTaskUiArn): java.lang.String)
      .humanTaskUiName(
        HumanTaskUiName.unwrap(humanTaskUiName): java.lang.String
      )
      .optionallyWith(humanTaskUiStatus.map(value => value.unwrap))(
        _.humanTaskUiStatus
      )
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .uiTemplate(uiTemplate.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeHumanTaskUiResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeHumanTaskUiResponse.wrap(buildAwsValue())
}
object DescribeHumanTaskUiResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeHumanTaskUiResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeHumanTaskUiResponse =
      zio.aws.sagemaker.model.DescribeHumanTaskUiResponse(
        humanTaskUiArn,
        humanTaskUiName,
        humanTaskUiStatus.map(value => value),
        creationTime,
        uiTemplate.asEditable
      )
    def humanTaskUiArn: HumanTaskUiArn
    def humanTaskUiName: HumanTaskUiName
    def humanTaskUiStatus: Optional[zio.aws.sagemaker.model.HumanTaskUiStatus]
    def creationTime: Timestamp
    def uiTemplate: zio.aws.sagemaker.model.UiTemplateInfo.ReadOnly
    def getHumanTaskUiArn: ZIO[Any, Nothing, HumanTaskUiArn] =
      ZIO.succeed(humanTaskUiArn)
    def getHumanTaskUiName: ZIO[Any, Nothing, HumanTaskUiName] =
      ZIO.succeed(humanTaskUiName)
    def getHumanTaskUiStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.HumanTaskUiStatus] =
      AwsError.unwrapOptionField("humanTaskUiStatus", humanTaskUiStatus)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getUiTemplate
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.UiTemplateInfo.ReadOnly] =
      ZIO.succeed(uiTemplate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeHumanTaskUiResponse
  ) extends zio.aws.sagemaker.model.DescribeHumanTaskUiResponse.ReadOnly {
    override val humanTaskUiArn: HumanTaskUiArn =
      zio.aws.sagemaker.model.primitives.HumanTaskUiArn(impl.humanTaskUiArn())
    override val humanTaskUiName: HumanTaskUiName =
      zio.aws.sagemaker.model.primitives.HumanTaskUiName(impl.humanTaskUiName())
    override val humanTaskUiStatus
        : Optional[zio.aws.sagemaker.model.HumanTaskUiStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.humanTaskUiStatus())
        .map(value => zio.aws.sagemaker.model.HumanTaskUiStatus.wrap(value))
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val uiTemplate: zio.aws.sagemaker.model.UiTemplateInfo.ReadOnly =
      zio.aws.sagemaker.model.UiTemplateInfo.wrap(impl.uiTemplate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeHumanTaskUiResponse
  ): zio.aws.sagemaker.model.DescribeHumanTaskUiResponse.ReadOnly = new Wrapper(
    impl
  )
}
