package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{FilterValue, ResourcePropertyName}
import scala.jdk.CollectionConverters.*
final case class Filter(
    name: ResourcePropertyName,
    operator: Optional[zio.aws.sagemaker.model.Operator] = Optional.Absent,
    value: Optional[FilterValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Filter
      .builder()
      .name(ResourcePropertyName.unwrap(name): java.lang.String)
      .optionallyWith(operator.map(value => value.unwrap))(_.operator)
      .optionallyWith(
        value.map(value => FilterValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Filter.ReadOnly =
    zio.aws.sagemaker.model.Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sagemaker.model.Filter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Filter = zio.aws.sagemaker.model
      .Filter(name, operator.map(value => value), value.map(value => value))
    def name: ResourcePropertyName
    def operator: Optional[zio.aws.sagemaker.model.Operator]
    def value: Optional[FilterValue]
    def getName: ZIO[Any, Nothing, ResourcePropertyName] = ZIO.succeed(name)
    def getOperator: ZIO[Any, AwsError, zio.aws.sagemaker.model.Operator] =
      AwsError.unwrapOptionField("operator", operator)
    def getValue: ZIO[Any, AwsError, FilterValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Filter
  ) extends zio.aws.sagemaker.model.Filter.ReadOnly {
    override val name: ResourcePropertyName =
      zio.aws.sagemaker.model.primitives.ResourcePropertyName(impl.name())
    override val operator: Optional[zio.aws.sagemaker.model.Operator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operator())
        .map(value => zio.aws.sagemaker.model.Operator.wrap(value))
    override val value: Optional[FilterValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.sagemaker.model.primitives.FilterValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Filter
  ): zio.aws.sagemaker.model.Filter.ReadOnly = new Wrapper(impl)
}
