package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EdgeVersion
import scala.jdk.CollectionConverters.*
final case class AgentVersion(version: EdgeVersion, agentCount: Long) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AgentVersion = {
    import AgentVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AgentVersion
      .builder()
      .version(EdgeVersion.unwrap(version): java.lang.String)
      .agentCount(agentCount: java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AgentVersion.ReadOnly =
    zio.aws.sagemaker.model.AgentVersion.wrap(buildAwsValue())
}
object AgentVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AgentVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AgentVersion =
      zio.aws.sagemaker.model.AgentVersion(version, agentCount)
    def version: EdgeVersion
    def agentCount: Long
    def getVersion: ZIO[Any, Nothing, EdgeVersion] = ZIO.succeed(version)
    def getAgentCount: ZIO[Any, Nothing, Long] = ZIO.succeed(agentCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AgentVersion
  ) extends zio.aws.sagemaker.model.AgentVersion.ReadOnly {
    override val version: EdgeVersion =
      zio.aws.sagemaker.model.primitives.EdgeVersion(impl.version())
    override val agentCount: Long = impl.agentCount(): Long
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AgentVersion
  ): zio.aws.sagemaker.model.AgentVersion.ReadOnly = new Wrapper(impl)
}
