package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.HyperParameterTuningJobName
import scala.jdk.CollectionConverters.*
final case class StopHyperParameterTuningJobRequest(
    hyperParameterTuningJobName: HyperParameterTuningJobName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.StopHyperParameterTuningJobRequest = {
    import StopHyperParameterTuningJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.StopHyperParameterTuningJobRequest
      .builder()
      .hyperParameterTuningJobName(
        HyperParameterTuningJobName.unwrap(
          hyperParameterTuningJobName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.StopHyperParameterTuningJobRequest.ReadOnly =
    zio.aws.sagemaker.model.StopHyperParameterTuningJobRequest
      .wrap(buildAwsValue())
}
object StopHyperParameterTuningJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.StopHyperParameterTuningJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.StopHyperParameterTuningJobRequest =
      zio.aws.sagemaker.model
        .StopHyperParameterTuningJobRequest(hyperParameterTuningJobName)
    def hyperParameterTuningJobName: HyperParameterTuningJobName
    def getHyperParameterTuningJobName
        : ZIO[Any, Nothing, HyperParameterTuningJobName] =
      ZIO.succeed(hyperParameterTuningJobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.StopHyperParameterTuningJobRequest
  ) extends zio.aws.sagemaker.model.StopHyperParameterTuningJobRequest.ReadOnly {
    override val hyperParameterTuningJobName: HyperParameterTuningJobName =
      zio.aws.sagemaker.model.primitives
        .HyperParameterTuningJobName(impl.hyperParameterTuningJobName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.StopHyperParameterTuningJobRequest
  ): zio.aws.sagemaker.model.StopHyperParameterTuningJobRequest.ReadOnly =
    new Wrapper(impl)
}
